package cn.schoolwow.ams.module.block.listBlock.clazzBlock.flow;

import cn.schoolwow.ams.module.block.listBlock.clazzBlock.domain.ClazzListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.initial.domain.InitialAMSContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetClazzListBlockContextFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = flowContext.checkData("projectName", String.class);
        String clazzName = flowContext.checkData("clazzName", String.class);
        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);

        for(ListBlockContext listBlockContext:initialAMSContext.listBlockContextList){
            if(!(listBlockContext instanceof ClazzListBlockContext)){
                continue;
            }
            ClazzListBlockContext clazzListBlockContext = (ClazzListBlockContext) listBlockContext;
            if(clazzListBlockContext.projectName.equalsIgnoreCase(projectName)
                    &&clazzListBlockContext.clazzName.equalsIgnoreCase(clazzName)){
                flowContext.putTemporaryInstanceData(clazzListBlockContext);
                flowContext.putTemporaryInstanceData(clazzListBlockContext, ListBlockContext.class);
                break;
            }
        }
        if(!flowContext.containInstanceKey(ClazzListBlockContext.class)){
            throw new IllegalArgumentException("查找Clazz列表上下文失败!项目名:"+projectName+",名称:"+clazzName);
        }
    }

    @Override
    public String name() {
        return "设置ClazzListBlock类型上下文数据";
    }
}
