package cn.schoolwow.ams.module.block.listBlock.clazzBlock.service;

import cn.schoolwow.ams.domain.block.list.clazz.crud.ClazzListBlockListListener;
import cn.schoolwow.ams.domain.block.list.common.ListBlockPagingResponse;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.domain.ClazzListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.flow.SetClazzListBlockContextFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class ClazzListBlockListServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetClazzListBlockContextFlow());

        String projectName = flowContext.checkData("projectName", String.class);
        String clazzName = flowContext.checkData("clazzName", String.class);
        ClazzListBlockContext clazzListBlockContext = flowContext.checkInstanceData(ClazzListBlockContext.class);
        JSONObject conditionMap = flowContext.checkData("conditionMap", JSONObject.class);

        ClazzListBlockListListener clazzListBlockListListener = clazzListBlockContext.clazzListBlockAPIListener.listListener;
        if(null== clazzListBlockListListener){
            throw new IllegalArgumentException("当前列表未配置分页查询逻辑!项目名:"+projectName+",clazz名称:"+clazzName);
        }
        ListBlockPagingResponse listBlockPagingResponse = clazzListBlockListListener.list(conditionMap);
        flowContext.putTemporaryInstanceData(listBlockPagingResponse);
    }

    @Override
    public String name() {
        return "ClazzListBlock类型的分页查询服务流程";
    }
}
