package cn.schoolwow.ams.module.block.listBlock.clazzBlock.service;

import cn.schoolwow.ams.domain.block.list.clazz.crud.ClazzListBlockUpdateListener;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.domain.ClazzListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.flow.SetClazzListBlockContextFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class ClazzListBlockUpdateServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetClazzListBlockContextFlow());

        String projectName = flowContext.checkData("projectName", String.class);
        String clazzName = flowContext.checkData("clazzName", String.class);
        ClazzListBlockContext clazzListBlockContext = flowContext.checkInstanceData(ClazzListBlockContext.class);
        JSONObject requestBody = flowContext.checkData("requestBody", JSONObject.class);

        ClazzListBlockUpdateListener clazzListBlockUpdateListener = clazzListBlockContext.clazzListBlockAPIListener.updateListener;
        if(null== clazzListBlockUpdateListener){
            throw new IllegalArgumentException("当前列表未配置编辑记录处理器!项目名:"+projectName+",clazz名称:"+clazzName);
        }
        clazzListBlockUpdateListener.update(requestBody);
    }

    @Override
    public String name() {
        return "ClazzListBlock类型的更新操作服务流程";
    }
}
