package cn.schoolwow.ams.module.block.listBlock.common.flow;

import cn.schoolwow.ams.domain.block.list.common.ListBlockButtonType;
import cn.schoolwow.ams.domain.block.list.common.ListBlockOption;
import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.remoteSelect.BlockRemoteSelect;
import cn.schoolwow.ams.module.block.listBlock.common.flow.buttonType.AddDatabaseTableListBlockContextButtonTypeFlow;
import cn.schoolwow.ams.module.block.listBlock.common.flow.buttonType.AddEntityTableListBlockContextButtonTypeFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.domain.DatabaseTableListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.domain.EntityTableListBlockContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.beanCopy.BeanCopy;
import org.springframework.beans.BeanUtils;

public class SetListBlockBasicInfoCommonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setBasicInfo(flowContext);
        addButtonType(flowContext);
    }

    @Override
    public String name() {
        return "设置DAOListBlock类型列表基础信息";
    }

    private void setBasicInfo(FlowContext flowContext){
        ListBlockOption listBlockOption = flowContext.checkInstanceData(ListBlockOption.class);
        ListBlockContext listBlockContext = flowContext.checkInstanceData(ListBlockContext.class);

        listBlockContext.listBlockContextOption.initialList = listBlockOption.listBlockShowOption.initialList;
        listBlockContext.listBlockContextOption.simulatePaging = listBlockOption.listBlockShowOption.simulatePaging;
        listBlockContext.listBlockContextOption.displayFieldNames = listBlockOption.listBlockShowOption.displayFieldNames;
        listBlockContext.listBlockContextOption.initialSortField = listBlockOption.listBlockShowOption.initialSortField;
        listBlockContext.listBlockContextOption.initialSortOrder = listBlockOption.listBlockShowOption.initialSortOrder;
        listBlockContext.listBlockContextOption.updateDisplayFieldNames = listBlockOption.listBlockShowOption.updateDisplayFieldNames;
        listBlockContext.listBlockContextOption.updateDisableFieldNames = listBlockOption.listBlockShowOption.updateDisableFieldNames;

//        BeanUtils.copyProperties(listBlockOption.listBlockShowOption, listBlockContext.listBlockContextOption);
//        BeanCopy.copyProperties(listBlockOption.listBlockShowOption, listBlockContext.listBlockContextOption);

        if(null!=listBlockOption.listBlockShowOption.listBlockButtonTypeArray){
            for(ListBlockButtonType listBlockButtonType:listBlockOption.listBlockShowOption.listBlockButtonTypeArray){
                listBlockContext.listBlockContextOption.buttonTypeList.add(listBlockButtonType.name());
            }
        }

        listBlockContext.listBlockContextOption.copyFieldCommentMap.putAll(listBlockOption.copyFieldCommentMap);
        listBlockContext.listBlockContextOption.blockRouterPushList.addAll(listBlockOption.blockRouterPushList);
        //检查级联
        for(BlockRemoteSelect blockRemoteSelect:listBlockOption.remoteSelectList){
            if(blockRemoteSelect.cascade&&null==blockRemoteSelect.options){
                throw new IllegalArgumentException("级联下拉框不支持远程搜索!名称:"+blockRemoteSelect.name+",标签:"+blockRemoteSelect.label);
            }
        }
        listBlockContext.listBlockContextOption.remoteSelectList.addAll(listBlockOption.remoteSelectList);

    }

    private void addButtonType(FlowContext flowContext){
        ListBlockContext listBlockContext = flowContext.checkInstanceData(ListBlockContext.class);

        if(listBlockContext instanceof EntityTableListBlockContext){
            flowContext.startFlow(new AddEntityTableListBlockContextButtonTypeFlow())
                    .putTemporaryInstanceData(listBlockContext, EntityTableListBlockContext.class)
                    .execute();
        }else if(listBlockContext instanceof DatabaseTableListBlockContext){
            flowContext.startFlow(new AddDatabaseTableListBlockContextButtonTypeFlow())
                    .putTemporaryInstanceData(listBlockContext, DatabaseTableListBlockContext.class)
                    .execute();
        }
    }
}
