package cn.schoolwow.ams.module.block.listBlock.common.flow.buttonType;

import cn.schoolwow.ams.domain.block.common.BlockOperationType;
import cn.schoolwow.ams.domain.block.common.operation.CustomerMessage;
import cn.schoolwow.ams.domain.block.list.common.ListBlockButtonType;
import cn.schoolwow.ams.domain.block.list.common.ListBlockOperationHandler;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.BlockOperationPosition;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockOperationContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockRequest;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.domain.DatabaseTableListBlockContext;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.query.instanceList.QueryInstanceList;

public class AddDatabaseTableListBlockContextButtonTypeFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseTableListBlockContext databaseTableListBlockContext = flowContext.checkInstanceData(DatabaseTableListBlockContext.class);

        if(databaseTableListBlockContext.listBlockContextOption.buttonTypeList.contains(ListBlockButtonType.CONDITION_DELETE.name())){
            ListBlockOperationContext listBlockOperationContext = new ListBlockOperationContext();
            listBlockOperationContext.type = BlockOperationType.ListBlockHandler.name();
            listBlockOperationContext.label = "条件删除";
            listBlockOperationContext.position = BlockOperationPosition.Search.name();
            listBlockOperationContext.buttonType = "danger";
            listBlockOperationContext.confirm = true;
            listBlockOperationContext.refreshList = true;
            listBlockOperationContext.listBlockOperationHandler = new ListBlockOperationHandler() {
                @Override
                public CustomerMessage handle(ListBlockRequest listBlockRequest) throws Exception {
                    if(null==listBlockRequest.search||listBlockRequest.search.isEmpty()){
                        throw new IllegalArgumentException("请先设置查询条件!");
                    }
                    Condition condition = databaseTableListBlockContext.dao.query(databaseTableListBlockContext.entity.clazz);
                    for(String key:listBlockRequest.search.keySet()){
                        Object value = listBlockRequest.search.get(key);
                        key = StringUtil.camel2Underline(key);
                        long count = QueryInstanceList.newQuery(databaseTableListBlockContext.entity.properties)
                                .addQuery("column", key)
                                .execute()
                                .count();
                        if(count>0){
                            condition.addQuery(key, value);
                        }
                    }
                    int effect = condition.execute().delete();
                    return null;
                }
            };
            databaseTableListBlockContext.listBlockContextOption.blockOperationContextList.add(listBlockOperationContext);
        }

        if(databaseTableListBlockContext.listBlockContextOption.buttonTypeList.contains(ListBlockButtonType.ALL_DELETE.name())){
            ListBlockOperationContext listBlockOperationContext = new ListBlockOperationContext();
            listBlockOperationContext.label = "";
            listBlockOperationContext.icon = "fa-remove";
            listBlockOperationContext.position = BlockOperationPosition.RightTop.name();
            listBlockOperationContext.buttonType = "danger";
            listBlockOperationContext.confirm = true;
            listBlockOperationContext.refreshList = true;
            listBlockOperationContext.listBlockOperationHandler = new ListBlockOperationHandler() {
                @Override
                public CustomerMessage handle(ListBlockRequest listBlockRequest) throws Exception {
                    databaseTableListBlockContext.dao.truncate(databaseTableListBlockContext.tableName);
                    return null;
                }
            };
            databaseTableListBlockContext.listBlockContextOption.blockOperationContextList.add(listBlockOperationContext);
        }
    }

    @Override
    public String name() {
        return "添加EntityTableList列表类型块按钮列表";
    }
}
