package cn.schoolwow.ams.module.block.listBlock.daoBlock.common.flow;

import cn.schoolwow.ams.domain.block.list.common.AMSFieldOption;
import cn.schoolwow.ams.domain.block.list.dao.crud.DatabaseListBlockListListener;
import cn.schoolwow.ams.domain.block.list.dao.crud.DatabaseListBlockListener;
import cn.schoolwow.ams.domain.block.list.dao.crud.DatabaseListBlockTableField;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.common.domain.DatabaseListBlockContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.ArrayList;
import java.util.List;

public class SetDAOListBlockAMSFieldOptionListCommonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setList(flowContext);
        addRequestFields(flowContext);
        addResponseFields(flowContext);
    }

    @Override
    public String name() {
        return "设置DAOListBlock块分页查询的字段列表";
    }

    private void setList(FlowContext flowContext){
        DatabaseListBlockContext amsDatabaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        DatabaseListBlockListener daoListBlockListAPIListener = amsDatabaseListBlockContext.databaseListBlockListener;
        if(null==daoListBlockListAPIListener){
            flowContext.brokenCurrentFlow("");
            return;
        }
        DatabaseListBlockListListener listAPIListener = daoListBlockListAPIListener.listListener;
        if(null==listAPIListener){
            flowContext.brokenCurrentFlow("");
            return;
        }
        DatabaseListBlockTableField[] databaseListBlockTableFields = listAPIListener.listTableFieldArray();
        if(null==databaseListBlockTableFields||databaseListBlockTableFields.length==0){
            flowContext.brokenCurrentFlow("");
            return;
        }

        List<AMSFieldOption> requestAMSFieldOptionList = new ArrayList<>();
        List<AMSFieldOption> responseAMSFieldOptionList = new ArrayList<>();
        for(DatabaseListBlockTableField databaseListBlockTableField : databaseListBlockTableFields){
            AMSFieldOption amsFieldOption = new AMSFieldOption();
            amsFieldOption.name = databaseListBlockTableField.name;
            amsFieldOption.label = databaseListBlockTableField.label;
            amsFieldOption.amsType = databaseListBlockTableField.type;
            responseAMSFieldOptionList.add(amsFieldOption);
            if(databaseListBlockTableField.requestField){
                requestAMSFieldOptionList.add(amsFieldOption);
            }
        }
        flowContext.putCurrentFlowData("requestAMSFieldOptionList", requestAMSFieldOptionList);
        flowContext.putCurrentFlowData("responseAMSFieldOptionList", responseAMSFieldOptionList);
    }

    private void addRequestFields(FlowContext flowContext){
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        List<AMSFieldOption> requestAMSFieldOptionList = (List<AMSFieldOption>) flowContext.getData("requestAMSFieldOptionList");
        if(null!=requestAMSFieldOptionList){
            for(AMSFieldOption amsFieldOption:requestAMSFieldOptionList){
                databaseListBlockContext.listBlockContextOption.requestFields.add(amsFieldOption);
            }
        }
    }

    private void addResponseFields(FlowContext flowContext){
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        List<AMSFieldOption> responseAMSFieldOptionList = (List<AMSFieldOption>) flowContext.getData("responseAMSFieldOptionList");
        if(null!=responseAMSFieldOptionList){
            for(AMSFieldOption amsFieldOption:responseAMSFieldOptionList){
                databaseListBlockContext.resourceBlockContextOption.responseFields.add(amsFieldOption);
            }
        }
    }
}
