package cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.controller;

import cn.schoolwow.ams.domain.block.list.common.ListBlockPagingResponse;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockRequest;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.service.DatabaseTableListBlockListServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.service.DatabaseTableListBlockUpdateServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.service.DatabaseTableListBlockUserOperationServiceFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("/ams/api/databaseTableListBlock")
public class DatabaseTableListBlockController {
    @Autowired
    private QuickFlow amsFlow;

    @RequestMapping("/{projectName}/{daoName}/{tableName}/list")
    public ListBlockPagingResponse list(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestParam Map<String,Object> conditionMap
    ) throws Exception {
        JSONObject queryCondition = new JSONObject(conditionMap);
        FlowContext flowContext = amsFlow.startFlow(new DatabaseTableListBlockListServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("queryCondition", queryCondition)
                .execute();
        ListBlockPagingResponse amsListBlockPagingResponse = flowContext.checkInstanceData(ListBlockPagingResponse.class);
        return amsListBlockPagingResponse;
    }

    @RequestMapping("/{projectName}/{daoName}/{tableName}/update")
    public void update(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody JSONObject requestBody
    ) throws Exception {
        amsFlow.startFlow(new DatabaseTableListBlockUpdateServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("requestBody", requestBody)
                .execute();
    }

    @RequestMapping("/{projectName}/{daoName}/{tableName}/userOperation")
    public JSONObject userOperation(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("tableName") String tableName,
            @RequestBody ListBlockRequest listBlockRequest
    ) {
        FlowContext flowContext = amsFlow.startFlow(new DatabaseTableListBlockUserOperationServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowInstanceData(listBlockRequest)
                .execute();
        JSONObject handleResult = flowContext.getData("handleResult", JSONObject.class);
        return handleResult;
    }
}
