package cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.flow;

import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.domain.DatabaseTableListBlockContext;
import cn.schoolwow.ams.module.initial.domain.InitialAMSContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetDatabaseTableListBlockContextFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);

        for(ListBlockContext listBlockContext:initialAMSContext.listBlockContextList){
            if(!(listBlockContext instanceof DatabaseTableListBlockContext)){
                continue;
            }
            DatabaseTableListBlockContext databaseTableListBlockContext = (DatabaseTableListBlockContext) listBlockContext;
            if(databaseTableListBlockContext.projectName.equalsIgnoreCase(projectName)
                    &&databaseTableListBlockContext.daoName.equalsIgnoreCase(daoName)
                    &&databaseTableListBlockContext.tableName.equalsIgnoreCase(tableName)
            ){
                flowContext.putTemporaryInstanceData(databaseTableListBlockContext);
                flowContext.putTemporaryInstanceData(databaseTableListBlockContext, ListBlockContext.class);
                break;
            }
        }
        if(!flowContext.containInstanceKey(DatabaseTableListBlockContext.class)){
            throw new IllegalArgumentException("查找DatabaseTable列表上下文失败!项目名:"+projectName+",数据库名:"+daoName+",表名:"+tableName);
        }
    }

    @Override
    public String name() {
        return "设置DatabaseTableListBlock类型上下文数据";
    }
}
