package cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.service;

import cn.schoolwow.ams.domain.block.list.common.ListBlockPagingResponse;
import cn.schoolwow.ams.domain.block.list.dao.crud.DatabaseListBlockListListener;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.domain.DatabaseTableListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.flow.SetDatabaseTableListBlockContextFlow;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.dto.FlowContextDataRange;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.query.instanceList.QueryInstanceList;
import com.alibaba.fastjson.JSONObject;

public class DatabaseTableListBlockListServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetDatabaseTableListBlockContextFlow());
        setDatabaseListBlockListListener(flowContext);
        setListBlockPagingResponse(flowContext);
    }

    @Override
    public String name() {
        return "DatabaseTableListBlock的分页查询服务流程";
    }

    private void setDatabaseListBlockListListener(FlowContext flowContext){
        DatabaseTableListBlockContext databaseTableListBlockContext = flowContext.checkInstanceData(DatabaseTableListBlockContext.class);

        DatabaseListBlockListListener databaseListBlockListListener = databaseTableListBlockContext.databaseListBlockListener.listListener;
        flowContext.putInstanceData(databaseListBlockListListener, FlowContextDataRange.CurrentFlow);
    }

    private void setListBlockPagingResponse(FlowContext flowContext) throws Exception {
        DatabaseTableListBlockContext databaseTableListBlockContext = flowContext.checkInstanceData(DatabaseTableListBlockContext.class);
        DatabaseListBlockListListener databaseListBlockListListener = flowContext.getInstanceData(DatabaseListBlockListListener.class);
        JSONObject queryCondition = (JSONObject) flowContext.checkData("queryCondition");

        int page = queryCondition.getIntValue("page");
        int pageSize = queryCondition.getIntValue("pageSize");
        Condition condition = databaseTableListBlockContext.dao.query(databaseTableListBlockContext.tableName)
                .page(page, pageSize);
        queryCondition.remove("page");
        queryCondition.remove("pageSize");
        if(null!=databaseListBlockListListener){
            databaseListBlockListListener.beforeExecuteCondition(condition, queryCondition);
        }
        for(String key:queryCondition.keySet()){
            key = StringUtil.camel2Underline(key);
            long count = QueryInstanceList.newQuery(databaseTableListBlockContext.entity.properties)
                    .addQuery("column", key)
                    .execute()
                    .count();
            if(count>0){
                condition.addQuery(key, queryCondition.get(key));
            }
        }
        PageVo pageVo = condition.execute().getPagingList();
        if(null!=databaseListBlockListListener){
            databaseListBlockListListener.afterExecuteCondition(condition, queryCondition, pageVo);
        }
        ListBlockPagingResponse listBlockPagingResponse = new ListBlockPagingResponse(pageVo.getArray());
        flowContext.putReturnData("listBlockPagingResponse", listBlockPagingResponse);
    }
}
