package cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.service;

import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockOperationContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockRequest;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.flow.SetDatabaseTableListBlockContextFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.query.instanceList.QueryInstanceList;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

public class DatabaseTableListBlockUserOperationServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetDatabaseTableListBlockContextFlow());

        ListBlockContext listBlockContext = flowContext.checkInstanceData(ListBlockContext.class);
        ListBlockRequest listBlockRequest = flowContext.checkInstanceData(ListBlockRequest.class);

        ListBlockOperationContext listBlockOperationContext = QueryInstanceList.newQuery(listBlockContext.listBlockContextOption.blockOperationContextList)
                .addQuery("label", listBlockRequest.label)
                .execute()
                .getOne();
        Validate.notNull(listBlockOperationContext, "当前列表未配置操作按钮执行逻辑!按钮名称:"+listBlockRequest.label);
        Object result = listBlockOperationContext.listBlockOperationHandler.handle(listBlockRequest);
        JSONObject handleResult = JSON.parseObject(JSON.toJSONString(result));
        flowContext.putReturnData("handleResult", handleResult);
    }

    @Override
    public String name() {
        return "DatabaseTableListBlock的用户操作服务流程";
    }

}
