package cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.controller;

import cn.schoolwow.ams.domain.block.list.common.ListBlockPagingResponse;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockRequest;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.service.EntityTableListBlockDeleteServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.service.EntityTableListBlockListServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.service.EntityTableListBlockUpdateServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.service.EntityTableListBlockUserOperationServiceFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("/ams/api/entityTableListBlock")
public class EntityTableListBlockController {
    @Autowired
    private QuickFlow amsFlow;

    @RequestMapping("/{projectName}/{daoName}/{entityClassName}/list")
    public ListBlockPagingResponse list(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("entityClassName") String entityClassName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) throws Exception {
        JSONObject conditionMap = new JSONObject(amsListConditionMap);
        FlowContext flowContext = amsFlow.startFlow(new EntityTableListBlockListServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("entityClassName", entityClassName)
                .putCurrentCompositeFlowData("conditionMap", conditionMap)
                .execute();
        ListBlockPagingResponse amsListBlockPagingResponse = flowContext.checkInstanceData(ListBlockPagingResponse.class);
        return amsListBlockPagingResponse;
    }

    @RequestMapping("/{projectName}/{daoName}/{entityClassName}/update")
    public void update(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("entityClassName") String entityClassName,
            @RequestBody JSONObject requestBody
    ) throws Exception {
        amsFlow.startFlow(new EntityTableListBlockUpdateServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("entityClassName", entityClassName)
                .putCurrentCompositeFlowData("requestBody", requestBody)
                .execute();
    }

    @PostMapping(value = "/{projectName}/{daoName}/{entityClassName}/delete")
    public void delete(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("entityClassName") String entityClassName,
            @RequestParam("id") String id
    ) throws Exception {
        amsFlow.startFlow(new EntityTableListBlockDeleteServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("entityClassName", entityClassName)
                .putCurrentCompositeFlowData("id", id)
                .execute();
    }

    @RequestMapping("/{projectName}/{daoName}/{entityClassName}/userOperation")
    public JSONObject userOperation(
            @PathVariable("projectName") String projectName,
            @PathVariable("daoName") String daoName,
            @PathVariable("entityClassName") String entityClassName,
            @RequestBody ListBlockRequest listBlockRequest
    ) {
        FlowContext flowContext = amsFlow.startFlow(new EntityTableListBlockUserOperationServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("entityClassName", entityClassName)
                .putCurrentCompositeFlowInstanceData(listBlockRequest)
                .execute();
        JSONObject handleResult = flowContext.getData("handleResult", JSONObject.class);
        return handleResult;
    }
}
