package cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.flow;

import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.domain.EntityTableListBlockContext;
import cn.schoolwow.ams.module.initial.domain.InitialAMSContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class SetEntityTableListBlockContextFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String entityClassName = (String) flowContext.checkData("entityClassName");
        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);

        for(ListBlockContext listBlockContext:initialAMSContext.listBlockContextList){
            if(!(listBlockContext instanceof EntityTableListBlockContext)){
                continue;
            }
            EntityTableListBlockContext entityTableListBlockContext = (EntityTableListBlockContext) listBlockContext;
            if(entityTableListBlockContext.projectName.equalsIgnoreCase(projectName)
                    && entityTableListBlockContext.daoName.equalsIgnoreCase(daoName)
                    && entityTableListBlockContext.entityClassName.equalsIgnoreCase(entityClassName)
            ){
                flowContext.putTemporaryInstanceData(entityTableListBlockContext);
                flowContext.putTemporaryInstanceData(entityTableListBlockContext, ListBlockContext.class);
                break;
            }
        }
        if(!flowContext.containInstanceKey(EntityTableListBlockContext.class)){
            throw new IllegalArgumentException("查找EntityTable列表上下文失败!项目名:"+projectName+",数据库名:"+daoName+",实体类名:"+entityClassName);
        }
    }

    @Override
    public String name() {
        return "设置EntityTableListBlock类型上下文数据";
    }
}
