package cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.service;

import cn.schoolwow.ams.domain.block.list.common.ListBlockPagingResponse;
import cn.schoolwow.ams.domain.block.list.dao.crud.DatabaseListBlockListListener;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.domain.EntityTableListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.flow.SetEntityTableListBlockContextFlow;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class EntityTableListBlockListServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetEntityTableListBlockContextFlow());
        setDatabaseListBlockListListener(flowContext);
        setCondition(flowContext);
        executeCondition(flowContext);
    }

    @Override
    public String name() {
        return "EntityTableListBlock的分页查询服务流程";
    }

    private void setDatabaseListBlockListListener(FlowContext flowContext){
        EntityTableListBlockContext entityTableListBlockContext = flowContext.checkInstanceData(EntityTableListBlockContext.class);

        DatabaseListBlockListListener databaseListBlockListListener = entityTableListBlockContext.databaseListBlockListener.listListener;
        flowContext.putCurrentFlowInstanceData(databaseListBlockListListener, DatabaseListBlockListListener.class);
    }

    private void setCondition(FlowContext flowContext) throws Exception {
        EntityTableListBlockContext entityTableListBlockContext = flowContext.checkInstanceData(EntityTableListBlockContext.class);
        DatabaseListBlockListListener databaseListBlockListListener = flowContext.getInstanceData(DatabaseListBlockListListener.class);
        JSONObject conditionMap = (JSONObject) flowContext.checkData("conditionMap");

        Condition condition = entityTableListBlockContext.dao.query(entityTableListBlockContext.entity.clazz);
        //分页
        {
            int page = conditionMap.getIntValue("page");
            int pageSize = conditionMap.getIntValue("pageSize");
            condition.page(page, pageSize);
            conditionMap.remove("page");
            conditionMap.remove("pageSize");
        }
        //排序
        {
            String sortField = conditionMap.getString("sortField");
            String sortOrder = conditionMap.getString("sortOrder");
            if(StringUtils.isNoneBlank(sortField)&&StringUtils.isNotBlank(sortOrder)){
                condition.order(sortField, sortOrder);
            }
        }
        if(null!=databaseListBlockListListener){
            databaseListBlockListListener.beforeExecuteCondition(condition, conditionMap);
        }
        //字段查询
        {
            for(String key:conditionMap.keySet()){
                if(null!=entityTableListBlockContext.entity.getPropertyByFieldNameOrColumnName(key)){
                    condition.addQuery(key, conditionMap.get(key));
                }
            }
        }
        flowContext.putCurrentFlowInstanceData(condition, Condition.class);
    }

    private void executeCondition(FlowContext flowContext) throws Exception {
        Condition condition = flowContext.checkInstanceData(Condition.class);
        DatabaseListBlockListListener databaseListBlockListListener = flowContext.getInstanceData(DatabaseListBlockListListener.class);
        JSONObject conditionMap = (JSONObject) flowContext.checkData("conditionMap");

        PageVo pageVo = condition.execute().getPagingList();
        if(null!=databaseListBlockListListener){
            databaseListBlockListListener.afterExecuteCondition(condition, conditionMap, pageVo);
        }
        ListBlockPagingResponse listBlockPagingResponse = new ListBlockPagingResponse(pageVo);
        flowContext.putTemporaryInstanceData(listBlockPagingResponse);
    }
}
