package cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.service;

import cn.schoolwow.ams.domain.block.list.dao.crud.DatabaseListBlockUpdateListener;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.domain.EntityTableListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.flow.SetEntityTableListBlockContextFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class EntityTableListBlockUpdateServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetEntityTableListBlockContextFlow());

        EntityTableListBlockContext entityTableListBlockContext = flowContext.checkInstanceData(EntityTableListBlockContext.class);
        JSONObject requestBody = flowContext.checkData("requestBody", JSONObject.class);

        DatabaseListBlockUpdateListener databaseListBlockUpdateListener = entityTableListBlockContext.databaseListBlockListener.updateListener;
        Object instance = requestBody.toJavaObject(entityTableListBlockContext.entity.clazz);
        if (null == databaseListBlockUpdateListener) {
            entityTableListBlockContext.dao.update(instance);
        } else {
            databaseListBlockUpdateListener.update(entityTableListBlockContext.dao, instance);
        }
    }

    @Override
    public String name() {
        return "EntityTableListBlock的更新记录服务流程";
    }

}
