package cn.schoolwow.ams.module.block.remoteSelect.controller;

import cn.schoolwow.ams.module.block.listBlock.common.domain.remoteSelect.RemoteSelectOption;
import cn.schoolwow.ams.module.block.remoteSelect.service.GetRemoteSelectOptionArrayServiceFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/ams/api/remoteSelect")
public class RemoteSelectController {
    @Autowired
    private QuickFlow amsFlow;

    @RequestMapping("/{uniqueKey}")
    public List<RemoteSelectOption> remoteSelect(
            @PathVariable("uniqueKey") String uniqueKey,
            @RequestParam Map<String,String> conditionMap
    ) throws Exception {
        String remoteLabel = conditionMap.get("remoteLabel");
        conditionMap.remove("remoteLabel");

        FlowContext flowContext = amsFlow.startFlow(new GetRemoteSelectOptionArrayServiceFlow())
                .putCurrentCompositeFlowData("uniqueKey", uniqueKey)
                .putCurrentCompositeFlowData("remoteLabel", remoteLabel)
                .putCurrentCompositeFlowData("conditionMap", conditionMap)
                .execute();
        List<RemoteSelectOption> remoteSelectOptionList = flowContext.getData("remoteSelectOptionList", List.class);
        return remoteSelectOptionList;
    }

}
