package cn.schoolwow.ams.module.block.remoteSelect.service;

import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.remoteSelect.BlockRemoteSelect;
import cn.schoolwow.ams.module.block.listBlock.common.domain.remoteSelect.RemoteSelectOption;
import cn.schoolwow.ams.module.initial.domain.InitialAMSContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.query.instanceList.QueryInstanceList;

import java.util.List;
import java.util.Map;

public class GetRemoteSelectOptionArrayServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String uniqueKey = flowContext.checkData("uniqueKey", String.class);
        String remoteLabel = flowContext.checkData("remoteLabel", String.class);
        Map<String,String> conditionMap = flowContext.getData("conditionMap", Map.class);
        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);

        for(ListBlockContext listBlockContext:initialAMSContext.listBlockContextList){
            if(!listBlockContext.uniqueKey.equalsIgnoreCase(uniqueKey)){
                continue;
            }
            if(listBlockContext.listBlockContextOption.remoteSelectList.isEmpty()){
                throw new IllegalArgumentException("当前页面未配置远程下拉框!");
            }
            BlockRemoteSelect blockRemoteSelect = QueryInstanceList.newQuery(listBlockContext.listBlockContextOption.remoteSelectList)
                    .addQuery("label", remoteLabel)
                    .execute()
                    .checkOne();
            List<RemoteSelectOption> remoteSelectOptionList = blockRemoteSelect.getRemoteSelectOption.getRemoteOption(conditionMap);
            flowContext.putReturnData("remoteSelectOptionList", remoteSelectOptionList);
        }
    }

    @Override
    public String name() {
        return "获取远程下拉框结果列表";
    }
}
