package cn.schoolwow.ams.module.config.bean;

import cn.schoolwow.ams.module.config.handler.AMSTryCatchFinallyHandler;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.QuickFlowBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ComponentScan(basePackages = "cn.schoolwow.ams")
public class AMSQuickFlowConfig {
    @Bean
    @Autowired
    public QuickFlow amsFlow(ApplicationContext applicationContext){
        QuickFlow amsFlow = QuickFlowBuilder.newInstance()
                .putContextTemporaryInstanceData(applicationContext, ApplicationContext.class)
                .putContextTemporaryInstanceData(applicationContext.getEnvironment(), Environment.class)
                .tryCatchFinallyHandler(new AMSTryCatchFinallyHandler());
        return amsFlow;
    }

}
