package cn.schoolwow.ams.module.config.bean;

import cn.schoolwow.ams.domain.response.AMSResult;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.lang.reflect.Method;

@ControllerAdvice
public class AMSResponseBodyAdvice implements ResponseBodyAdvice {
    @Override
    public boolean supports(MethodParameter returnType, Class converterType) {
        Method method = returnType.getMethod();
        if(null!=method&&"getAppPackJavaScript".equalsIgnoreCase(method.getName())){
            return false;
        }

        String className = returnType.getDeclaringClass().getName();
        if(className.startsWith("cn.schoolwow.ams")){
            return true;
        }
        return false;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof AMSResult) {
            return body;
        }
        return new AMSResult(body);
    }
}
