package cn.schoolwow.ams.module.initial.flow.clazzList;

import cn.schoolwow.ams.domain.annotation.*;
import cn.schoolwow.ams.domain.block.list.common.AMSFieldOption;
import cn.schoolwow.ams.module.block.listBlock.common.flow.HandleAPIFieldListenerCommonFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class InitialClazzListBlockFieldOptionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setAMSFieldLabel(flowContext);
        setAMSFieldType(flowContext);
        setAMSFieldInfo(flowContext);
        setAMSFieldDefaultValue(flowContext);
        setAMSFieldProperty(flowContext);
        flowContext.executeFlowList(new HandleAPIFieldListenerCommonFlow());
        checkAMSField(flowContext);
    }

    @Override
    public String name() {
        return "初始化ClazzListBlock类型的ams字段";
    }

    private void setAMSFieldLabel(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);
        AMSFieldLabel amsFieldLabel = amsFieldOption.entityField.getAnnotation(AMSFieldLabel.class);
        if(null!=amsFieldLabel){
            amsFieldOption.label = amsFieldLabel.value();
        }else{
            switch (amsFieldOption.entityField.getName()){
                case "id":{amsFieldOption.label ="自增id";}break;
                case "createdAt":{amsFieldOption.label ="创建时间";}break;
                case "updatedAt":{amsFieldOption.label ="更新时间";}break;
            }
        }
    }

    private void setAMSFieldType(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        AMSFieldType amsFieldType = amsFieldOption.entityField.getAnnotation(AMSFieldType.class);
        if(null!=amsFieldType){
            amsFieldOption.amsType = amsFieldType.value();
        }else{
            amsFieldOption.amsType = "text";
            switch (amsFieldOption.entityField.getType().getName()) {
                case "java.util.Date":
                case "java.sql.LocalDate":{
                    amsFieldOption.amsType = "date";
                }break;
                case "java.sql.Timestamp":
                case "java.sql.LocalDateTime": {
                    amsFieldOption.amsType = "datetime";
                }break;
                case "com.alibaba.fastjson.JSONObject":
                case "com.alibaba.fastjson.JSONArray":{
                    amsFieldOption.amsType = "textarea";
                }break;
            }
        }
    }

    private void setAMSFieldInfo(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        AMSFieldInfo amsFieldInfo = amsFieldOption.entityField.getAnnotation(AMSFieldInfo.class);
        if(null!=amsFieldInfo){
            amsFieldOption.info = amsFieldInfo.value();
        }
    }

    private void setAMSFieldDefaultValue(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        AMSFieldDefaultValue amsFieldDefaultValue = amsFieldOption.entityField.getAnnotation(AMSFieldDefaultValue.class);
        if(null!=amsFieldDefaultValue){
            amsFieldOption.defaultValue = amsFieldDefaultValue.value();
        }
    }

    private void setAMSFieldProperty(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        AMSFieldProperty amsFieldProperty = amsFieldOption.entityField.getAnnotation(AMSFieldProperty.class);
        if(null!=amsFieldProperty){
            amsFieldOption.props.put("disabled", amsFieldProperty.disable());
        }
    }

    private void checkAMSField(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        String className = amsFieldOption.entityField.getName();
        String entityFieldName = amsFieldOption.entityField.getName();
        Validate.notNull(amsFieldOption.label, "[ClazzListBlock]字段标签字段信息为空!"
                + "涉及类:"+className
                + ",涉及字段:"+entityFieldName
        );
        Validate.notNull(amsFieldOption.amsType, "[ClazzListBlock]字段ams类型信息为空!"
                + "涉及类:"+className
                + ",涉及字段:"+entityFieldName
        );
    }
}
