package cn.schoolwow.ams.module.initial.flow.clazzList;

import cn.schoolwow.ams.domain.block.common.BlockOption;
import cn.schoolwow.ams.domain.block.list.clazz.ClazzListBlockConfigAware;
import cn.schoolwow.ams.domain.block.list.clazz.ClazzListBlockOption;
import cn.schoolwow.ams.domain.block.list.common.ListBlockOption;
import cn.schoolwow.ams.module.block.common.domain.BlockContext;
import cn.schoolwow.ams.module.block.common.flow.SetBlockContextFieldValueFlow;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.domain.ClazzListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.common.flow.SetListBlockBasicInfoCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.common.flow.SetListBlockOperationCommonFlow;
import cn.schoolwow.ams.module.initial.domain.InitialAMSContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.check.instance.CheckInstance;
import org.springframework.context.ApplicationContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SetClazzListBlockContextListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkClazzListBlockOption(flowContext);
        setClazzListBlockContextListFlow(flowContext);
    }

    @Override
    public String name() {
        return "设置ClazzListBlockContext列表";
    }

    private void checkClazzListBlockOption(FlowContext flowContext){
        ApplicationContext applicationContext = flowContext.checkInstanceData(ApplicationContext.class);
        Map<String, ClazzListBlockConfigAware> map = applicationContext.getBeansOfType(ClazzListBlockConfigAware.class);

        if(map.isEmpty()){
            flowContext.brokenCurrentFlow("无ClazzListBlock配置类列表信息");
        }
        List<ClazzListBlockOption> clazzListBlockOptionList = new ArrayList<>();
        for(ClazzListBlockConfigAware clazzListBlockConfigAware : map.values()){
            ClazzListBlockOption clazzListBlockOption = clazzListBlockConfigAware.getAMSBlockConfig();
            clazzListBlockOption.routerBlock = clazzListBlockConfigAware;

            String className = clazzListBlockConfigAware.getClass().getName();
            CheckInstance.newCheck()
                    .notNullCheck(clazzListBlockOption, "clazz表配置,涉及类名:["+className+"]")
                    .notEmptyCheck(clazzListBlockOption.projectName, "项目名称,涉及类名:["+className+"]")
                    .notEmptyCheck(clazzListBlockOption.displayName, "表显示名称,涉及类名:["+className+"]")
                    .notNullCheck(clazzListBlockOption.requestClass, "请求类,涉及类名:["+className+"]")
                    .notNullCheck(clazzListBlockOption.responseClass, "响应类,涉及类名:["+className+"]")
                    .notEmptyCheck(clazzListBlockOption.clazzName, "唯一AMS类名,涉及类名:["+className+"]");
            clazzListBlockOptionList.add(clazzListBlockOption);
        }
        flowContext.putContextData("clazzListBlockOptionList", clazzListBlockOptionList);
    }

    private void setClazzListBlockContextListFlow(FlowContext flowContext){
        List<ClazzListBlockOption> clazzListBlockOptionList = (List<ClazzListBlockOption>) flowContext.checkData("clazzListBlockOptionList");
        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);

        for(ClazzListBlockOption clazzListBlockOption:clazzListBlockOptionList){
            ClazzListBlockContext clazzListBlockContext = new ClazzListBlockContext();

            flowContext.putTemporaryInstanceData(clazzListBlockContext)
                    .putTemporaryInstanceData(clazzListBlockOption)
                    .putTemporaryInstanceData(clazzListBlockOption, ListBlockOption.class)
                    .putTemporaryInstanceData(clazzListBlockContext, ListBlockContext.class)
                    .putTemporaryInstanceData(clazzListBlockOption, BlockOption.class)
                    .putTemporaryInstanceData(clazzListBlockContext, BlockContext.class);

            flowContext.executeFlowList(new SetBlockContextFieldValueFlow());
            setResourceBlockBasicInfo(flowContext);
            setClazzBlockResponseFieldsFlow(flowContext);
            setListBlockBasicInfo(flowContext);
            flowContext.executeFlowList(new SetListBlockBasicInfoCommonFlow());
            setClazzBlockRequestFieldsFlow(flowContext);
            flowContext.executeFlowList(new SetListBlockOperationCommonFlow());

            initialAMSContext.listBlockContextList.add(clazzListBlockContext);
        }
    }

    private void setResourceBlockBasicInfo(FlowContext flowContext){
        ClazzListBlockOption amsClazzListBlockOption = flowContext.checkInstanceData(ClazzListBlockOption.class);
        ClazzListBlockContext amsClazzListBlockContext = flowContext.checkInstanceData(ClazzListBlockContext.class);

        amsClazzListBlockContext.resourceBlockContextOption.idField = amsClazzListBlockOption.listBlockShowOption.idField;
        amsClazzListBlockContext.resourceBlockContextOption.apiPrefix = "clazzListBlock/"+ amsClazzListBlockOption.projectName+"/"+ amsClazzListBlockOption.clazzName;
    }

    private void setClazzBlockResponseFieldsFlow(FlowContext flowContext){
        ClazzListBlockOption amsClazzListBlockOption = flowContext.checkInstanceData(ClazzListBlockOption.class);
        ClazzListBlockContext amsClazzListBlockContext = flowContext.checkInstanceData(ClazzListBlockContext.class);

        flowContext.startFlow(new SetClazzListBlockFieldsFlow())
                .putCurrentCompositeFlowData("entityClass", amsClazzListBlockOption.responseClass)
                .putCurrentCompositeFlowData("fieldNames", amsClazzListBlockOption.listBlockShowOption.responseFieldNames)
                .putCurrentCompositeFlowData("amsFieldOptionList", amsClazzListBlockContext.resourceBlockContextOption.responseFields)
                .execute();
    }

    private void setListBlockBasicInfo(FlowContext flowContext){
        ClazzListBlockOption amsClazzListBlockOption = flowContext.checkInstanceData(ClazzListBlockOption.class);
        ClazzListBlockContext amsClazzListBlockContext = flowContext.checkInstanceData(ClazzListBlockContext.class);

        amsClazzListBlockContext.clazzName = amsClazzListBlockOption.clazzName;
        amsClazzListBlockContext.clazzListBlockAPIListener = amsClazzListBlockOption.clazzListBlockAPIListener;
    }

    private void setClazzBlockRequestFieldsFlow(FlowContext flowContext){
        ClazzListBlockOption amsClazzListBlockOption = flowContext.checkInstanceData(ClazzListBlockOption.class);
        ClazzListBlockContext amsClazzListBlockContext = flowContext.checkInstanceData(ClazzListBlockContext.class);

        if(null==amsClazzListBlockOption.listBlockShowOption.requestFieldNames||amsClazzListBlockOption.listBlockShowOption.requestFieldNames.length==0){
            return;
        }
        flowContext.startFlow(new SetClazzListBlockFieldsFlow())
                .putCurrentCompositeFlowData("entityClass", amsClazzListBlockOption.requestClass)
                .putCurrentCompositeFlowData("fieldNames", amsClazzListBlockOption.listBlockShowOption.requestFieldNames)
                .putCurrentCompositeFlowData("amsFieldOptionList", amsClazzListBlockContext.listBlockContextOption.requestFields)
                .execute();
    }
}
