package cn.schoolwow.ams.module.initial.flow.daoList.database;

import cn.schoolwow.ams.domain.block.list.common.AMSFieldOption;
import cn.schoolwow.ams.domain.block.list.dao.databaseTable.DatabaseTableListBlockOption;
import cn.schoolwow.ams.module.block.listBlock.common.flow.SetListBlockBasicInfoCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.common.flow.SetListBlockOperationCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.common.domain.DatabaseListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.common.flow.SetDAOListBlockAMSFieldOptionListCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.domain.DatabaseTableListBlockContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class InitialDatabaseTableListBlockContextFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        flowContext.executeFlowList(new SetDAOListBlockAMSFieldOptionListCommonFlow());
        setResourceBlockBasicInfo(flowContext);
        setResponseFields(flowContext);
        setListBlockBasicInfo(flowContext);
        flowContext.executeFlowList(new SetListBlockBasicInfoCommonFlow());
        setRequestFields(flowContext);
        flowContext.executeFlowList(new SetListBlockOperationCommonFlow());
    }

    @Override
    public String name() {
        return "初始化单个DatabaseTableListBlock块上下文信息";
    }

    private void setResourceBlockBasicInfo(FlowContext flowContext){
        DatabaseTableListBlockOption amsDatabaseTableListBlockOption = flowContext.checkInstanceData(DatabaseTableListBlockOption.class);
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        databaseListBlockContext.resourceBlockContextOption.idField = amsDatabaseTableListBlockOption.listBlockShowOption.idField;
        databaseListBlockContext.resourceBlockContextOption.apiPrefix = "databaseTableListBlock/"+ amsDatabaseTableListBlockOption.projectName
                +"/"+ amsDatabaseTableListBlockOption.daoName
                +"/"+ amsDatabaseTableListBlockOption.tableName;
    }

    private void setResponseFields(FlowContext flowContext){
        DatabaseTableListBlockOption databaseTableListBlockOption = flowContext.checkInstanceData(DatabaseTableListBlockOption.class);
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        flowContext.startFlow(new SetDatabaseTableListBlockFieldsFlow())
                .putCurrentCompositeFlowData("entity", databaseListBlockContext.entity)
                .putCurrentCompositeFlowData("fieldNames", databaseTableListBlockOption.listBlockShowOption.responseFieldNames)
                .putCurrentCompositeFlowData("amsFieldOptionList", databaseListBlockContext.resourceBlockContextOption.responseFields)
                .execute();

        //添加分页查询的响应字段
        List<AMSFieldOption> responseAMSFieldOptionList = (List<AMSFieldOption>) flowContext.getData("responseAMSFieldOptionList");
        if(null!=responseAMSFieldOptionList){
            for(AMSFieldOption amsFieldOption:responseAMSFieldOptionList){
                databaseListBlockContext.resourceBlockContextOption.responseFields.add(amsFieldOption);
            }
        }
    }

    private void setListBlockBasicInfo(FlowContext flowContext){
        DatabaseTableListBlockContext databaseTableListBlockContext = flowContext.checkInstanceData(DatabaseTableListBlockContext.class);
        DatabaseTableListBlockOption databaseTableListBlockOption = flowContext.checkInstanceData(DatabaseTableListBlockOption.class);

        databaseTableListBlockContext.daoName = databaseTableListBlockOption.daoName;
        databaseTableListBlockContext.tableName = databaseTableListBlockOption.tableName;
        databaseTableListBlockContext.databaseListBlockListener = databaseTableListBlockOption.databaseListBlockListener;
    }

    private void setRequestFields(FlowContext flowContext){
        DatabaseTableListBlockOption databaseTableListBlockOption = flowContext.checkInstanceData(DatabaseTableListBlockOption.class);
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        flowContext.startFlow(new SetDatabaseTableListBlockFieldsFlow())
                .putCurrentCompositeFlowData("entity", databaseListBlockContext.entity)
                .putCurrentCompositeFlowData("fieldNames", databaseTableListBlockOption.listBlockShowOption.requestFieldNames)
                .putCurrentCompositeFlowData("amsFieldOptionList", databaseListBlockContext.listBlockContextOption.requestFields)
                .execute();
    }
}
