package cn.schoolwow.ams.module.initial.flow.daoList.database;

import cn.schoolwow.ams.domain.block.list.common.AMSFieldOption;
import cn.schoolwow.ams.module.block.listBlock.common.flow.HandleAPIFieldListenerCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.common.domain.DatabaseListBlockContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class InitialDatabaseTableListBlockFieldOptionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setAMSFieldLabel(flowContext);
        setAMSFieldType(flowContext);
        flowContext.executeFlowList(new HandleAPIFieldListenerCommonFlow());
        checkAMSField(flowContext);
    }

    @Override
    public String name() {
        return "初始化DatabaseTableListBlock类型的ams字段";
    }

    private void setAMSFieldLabel(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);
        switch (amsFieldOption.property.column){
            case "id":{amsFieldOption.label ="自增id";}break;
            case "created_at":{amsFieldOption.label ="创建时间";}break;
            case "updated_at":{amsFieldOption.label ="更新时间";}break;
            default:{
                amsFieldOption.label = amsFieldOption.property.comment;
            }
        }
    }

    private void setAMSFieldType(FlowContext flowContext){
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        String javaType = databaseListBlockContext.dao.getDatabaseProvider().convertColumnTypeToJavaType(amsFieldOption.property.columnType);
        switch (javaType) {
            case "java.util.Date":
            case "java.sql.LocalDate":{
                amsFieldOption.amsType = "date";
            }break;
            case "java.sql.Timestamp":
            case "java.sql.LocalDateTime": {
                amsFieldOption.amsType = "datetime";
            }break;
            case "com.alibaba.fastjson.JSONObject":
            case "com.alibaba.fastjson.JSONArray":{
                amsFieldOption.amsType = "textarea";
            }break;
            default:{
                amsFieldOption.amsType = "text";
            }
        }
    }

    private void checkAMSField(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        String tableName = amsFieldOption.entityField.getName();
        String column = amsFieldOption.entityField.getName();
        Validate.notNull(amsFieldOption.label, "[DatabaseTableListBlock]字段标签字段信息为空!"
                + "涉及表名:"+tableName + ",涉及字段:"+column
        );
        Validate.notNull(amsFieldOption.amsType, "[DatabaseTableListBlock]字段ams类型信息为空!"
                + "涉及表名:"+tableName + ",涉及字段:"+column
        );
    }
}
