package cn.schoolwow.ams.module.initial.flow.daoList.entity;

import cn.schoolwow.ams.domain.block.list.dao.entityTable.EntityTableListBlockOption;
import cn.schoolwow.ams.module.block.listBlock.common.flow.SetListBlockBasicInfoCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.common.flow.SetListBlockOperationCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.common.domain.DatabaseListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.common.flow.SetDAOListBlockAMSFieldOptionListCommonFlow;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.domain.EntityTableListBlockContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class InitialEntityTableListBlockContextFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setResourceBlockBasicInfo(flowContext);
        setResponseFields(flowContext);
        setListBlockBasicInfo(flowContext);
        flowContext.executeFlowList(new SetListBlockBasicInfoCommonFlow());
        setRequestFields(flowContext);
        flowContext.executeFlowList(new SetListBlockOperationCommonFlow());
        flowContext.executeFlowList(new SetDAOListBlockAMSFieldOptionListCommonFlow());
    }

    @Override
    public String name() {
        return "初始化单个EntityTableListBlock块上下文信息";
    }

    private void setResourceBlockBasicInfo(FlowContext flowContext){
        EntityTableListBlockOption entityTableListBlockOption = flowContext.checkInstanceData(EntityTableListBlockOption.class);
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        databaseListBlockContext.resourceBlockContextOption.idField = entityTableListBlockOption.listBlockShowOption.idField;
        databaseListBlockContext.resourceBlockContextOption.apiPrefix = "entityTableListBlock/"+ entityTableListBlockOption.projectName
                +"/"+ entityTableListBlockOption.daoName
                +"/"+ entityTableListBlockOption.entityClass.getSimpleName();
    }

    private void setResponseFields(FlowContext flowContext){
        EntityTableListBlockOption entityTableListBlockOption = flowContext.checkInstanceData(EntityTableListBlockOption.class);
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        flowContext.startFlow(new SetEntityTableListBlockFieldsFlow())
                .putCurrentCompositeFlowData("entity", databaseListBlockContext.entity)
                .putCurrentCompositeFlowData("fieldNames", entityTableListBlockOption.listBlockShowOption.responseFieldNames)
                .putCurrentCompositeFlowData("amsFieldOptionList", databaseListBlockContext.resourceBlockContextOption.responseFields)
                .execute();
    }

    private void setListBlockBasicInfo(FlowContext flowContext){
        EntityTableListBlockContext entityTableListBlockContext = flowContext.checkInstanceData(EntityTableListBlockContext.class);
        EntityTableListBlockOption entityTableListBlockOption = flowContext.checkInstanceData(EntityTableListBlockOption.class);

        entityTableListBlockContext.daoName = entityTableListBlockOption.daoName;
        entityTableListBlockContext.entityClassName = entityTableListBlockOption.entityClass.getSimpleName();
        entityTableListBlockContext.databaseListBlockListener = entityTableListBlockOption.databaseListBlockListener;
    }

    private void setRequestFields(FlowContext flowContext){
        EntityTableListBlockOption entityTableListBlockOption = flowContext.checkInstanceData(EntityTableListBlockOption.class);
        DatabaseListBlockContext databaseListBlockContext = flowContext.checkInstanceData(DatabaseListBlockContext.class);

        if(null==entityTableListBlockOption.listBlockShowOption.requestFieldNames
                ||entityTableListBlockOption.listBlockShowOption.requestFieldNames.length==0){
            return;
        }
        flowContext.startFlow(new SetEntityTableListBlockFieldsFlow())
                .putCurrentCompositeFlowData("entity", databaseListBlockContext.entity)
                .putCurrentCompositeFlowData("fieldNames", entityTableListBlockOption.listBlockShowOption.requestFieldNames)
                .putCurrentCompositeFlowData("amsFieldOptionList", databaseListBlockContext.listBlockContextOption.requestFields)
                .execute();
    }
}
