package cn.schoolwow.ams.module.initial.flow.daoList.entity;

import cn.schoolwow.ams.domain.block.list.common.AMSFieldOption;
import cn.schoolwow.ams.module.block.listBlock.common.flow.HandleAPIFieldListenerCommonFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;

public class InitialEntityTableListBlockFieldOptionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setAMSFieldLabel(flowContext);
        setAMSFieldType(flowContext);
        flowContext.executeFlowList(new HandleAPIFieldListenerCommonFlow());
        checkAMSField(flowContext);
    }

    @Override
    public String name() {
        return "初始化EntityTableListBlock类型的ams字段";
    }

    private void setAMSFieldLabel(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);
        switch (amsFieldOption.property.column){
            case "id":{
                amsFieldOption.label ="自增id";
                amsFieldOption.amsType = "text";
            }break;
            case "created_at":{
                amsFieldOption.label ="创建时间";
                amsFieldOption.amsType = "datetime";
            }break;
            case "updated_at":{
                amsFieldOption.label ="更新时间";
                amsFieldOption.amsType = "datetime";
            }break;
            default:{
                amsFieldOption.label = amsFieldOption.property.comment;
            }
        }
    }

    private void setAMSFieldType(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        if(null!=amsFieldOption.amsType){
            return;
        }
        String javaType = amsFieldOption.property.field.getType().getName();
        switch (javaType) {
            case "java.util.Date":
            case "java.sql.LocalDate":{
                amsFieldOption.amsType = "date";
            }break;
            case "java.sql.Timestamp":
            case "java.sql.LocalDateTime": {
                amsFieldOption.amsType = "datetime";
            }break;
            case "com.alibaba.fastjson.JSONObject":
            case "com.alibaba.fastjson.JSONArray":{
                amsFieldOption.amsType = "textarea";
            }break;
            default:{
                amsFieldOption.amsType = "text";
            }
        }
    }

    private void checkAMSField(FlowContext flowContext){
        AMSFieldOption amsFieldOption = flowContext.checkInstanceData(AMSFieldOption.class);

        String entityName = amsFieldOption.property.entity.clazz.getName();
        String name = amsFieldOption.property.name;
        Validate.notNull(amsFieldOption.label, "[EntityTableListBlock]字段标签字段信息为空!"
                + "涉及实体类名:"+entityName + ",涉及字段:"+name
        );
        Validate.notNull(amsFieldOption.amsType, "[EntityTableListBlock]字段ams类型信息为空!"
                + "涉及实体类名:"+entityName + ",涉及字段:"+name
        );
    }
}
