package cn.schoolwow.ams.module.initial.service;

import cn.schoolwow.ams.domain.option.QuickAMSOption;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.query.resource.QueryResource;
import cn.schoolwow.util.domain.query.resource.QueryResourceResponse;
import cn.schoolwow.util.module.query.resource.domain.SingleQueryResourceHandler;
import org.springframework.context.ApplicationContext;

public class GetAppPackJavaScriptServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ApplicationContext applicationContext = flowContext.checkInstanceData(ApplicationContext.class);
        QuickAMSOption quickAMSOption = applicationContext.getBean(QuickAMSOption.class);

        if(flowContext.containKey("appPackJavaScript")&&!quickAMSOption.debug){
            return;
        }
        setBuilder(flowContext);
        mergeLoadScript(flowContext);
        mergeUserCustomerScript(flowContext);
        setAppPackJavaScript(flowContext);
    }

    @Override
    public String name() {
        return "获取合并javascript文件服务流程";
    }

    private void setBuilder(FlowContext flowContext){
        StringBuilder builder = new StringBuilder();
        flowContext.putCurrentFlowData("builder", builder);
    }

    private void mergeLoadScript(FlowContext flowContext){
        StringBuilder builder = (StringBuilder) flowContext.checkData("builder");

        QueryResource.newQuery("js流程", "static/ams/load")
                .fileNameEndWith(".js")
                .singleQueryResourceHandler(new SingleQueryResourceHandler() {
                    @Override
                    public boolean handleQueryResourceResponse(QueryResourceResponse queryResourceResponse) {
                        String content = queryResourceResponse.getAsString();
                        builder.append(content+"\r\n");
                        return true;
                    }
                })
                .execute()
                .walkResource();
    }

    private void mergeUserCustomerScript(FlowContext flowContext){
        StringBuilder builder = (StringBuilder) flowContext.checkData("builder");

        QueryResource.newQuery("自定义block", "static/ams/customer")
                .fileNameEndWith(".js")
                .checkExist(false)
                .singleQueryResourceHandler(new SingleQueryResourceHandler() {
                    @Override
                    public boolean handleQueryResourceResponse(QueryResourceResponse queryResourceResponse) {
                        String content = queryResourceResponse.getAsString();
                        builder.append(content+"\r\n");
                        return true;
                    }
                })
                .execute()
                .walkResource();
        flowContext.putContextData("appPackJavaScript", builder.toString());
    }

    private void setAppPackJavaScript(FlowContext flowContext){
        StringBuilder builder = (StringBuilder) flowContext.checkData("builder");

        flowContext.putContextData("appPackJavaScript", builder.toString());
    }

}
