package cn.schoolwow.ams.module.initial.service;

import cn.schoolwow.ams.domain.block.common.BlockOption;
import cn.schoolwow.ams.domain.block.form.FormBlockConfigAware;
import cn.schoolwow.ams.domain.block.form.FormBlockOption;
import cn.schoolwow.ams.domain.block.list.common.ListBlockOption;
import cn.schoolwow.ams.domain.block.list.dao.databaseTable.DatabaseTableListBlockConfigAware;
import cn.schoolwow.ams.domain.block.list.dao.databaseTable.DatabaseTableListBlockOption;
import cn.schoolwow.ams.domain.block.list.dao.entityTable.EntityTableListBlockConfigAware;
import cn.schoolwow.ams.domain.block.list.dao.entityTable.EntityTableListBlockOption;
import cn.schoolwow.ams.domain.block.router.RouterBlockBuilder;
import cn.schoolwow.ams.domain.option.QuickAMSListener;
import cn.schoolwow.ams.domain.option.QuickAMSOption;
import cn.schoolwow.ams.module.block.common.domain.BlockContext;
import cn.schoolwow.ams.module.block.common.flow.SetBlockContextFieldValueFlow;
import cn.schoolwow.ams.module.block.common.flow.SetBlockOperationCommonFlow;
import cn.schoolwow.ams.module.block.form.domain.FormBlockContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.context.ListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.common.domain.DatabaseListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.databaseTable.domain.DatabaseTableListBlockContext;
import cn.schoolwow.ams.module.block.listBlock.daoBlock.entityTable.domain.EntityTableListBlockContext;
import cn.schoolwow.ams.module.initial.domain.InitialAMSContext;
import cn.schoolwow.ams.module.initial.flow.clazzList.SetClazzListBlockContextListFlow;
import cn.schoolwow.ams.module.initial.flow.clazzList.SetClazzListBlockFieldsFlow;
import cn.schoolwow.ams.module.initial.flow.daoList.database.InitialDatabaseTableListBlockContextFlow;
import cn.schoolwow.ams.module.initial.flow.daoList.entity.InitialEntityTableListBlockContextFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.check.instance.CheckInstance;
import org.apache.commons.lang3.Validate;
import org.springframework.context.ApplicationContext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class InitialAMSContextServiceFlow implements BusinessFlow {

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        checkInitialAMSContextExist(flowContext);
        initialClazzListBlockListFlow(flowContext);
        setDatabaseTableListBlockOptionList(flowContext);
        setEntityTableListBlockOptionList(flowContext);
        initialFormBlockList(flowContext);
        setAMSRouterMenuArrayFlow(flowContext);
    }

    @Override
    public String name() {
        return "初始化AMS上下文信息服务流程";
    }

    private void checkInitialAMSContextExist(FlowContext flowContext){
        ApplicationContext applicationContext = flowContext.checkInstanceData(ApplicationContext.class);

        Collection<QuickAMSListener> quickAMSListenerCollection = applicationContext.getBeansOfType(QuickAMSListener.class).values();
        List<QuickAMSListener> quickAMSListenerList = new ArrayList<>(quickAMSListenerCollection);
        QuickAMSOption quickAMSOption = applicationContext.getBean(QuickAMSOption.class);

        flowContext.putTemporaryInstanceData(quickAMSOption);
        flowContext.putContextData("quickAMSListenerList", quickAMSListenerList);

        if(flowContext.containKey("initialAMSContext")&&!quickAMSOption.debug){
            flowContext.brokenCurrentFlow("初始化已经完成");
        }

        InitialAMSContext initialAMSContext = new InitialAMSContext();
        flowContext.putContextTemporaryInstanceData(initialAMSContext);
    }

    private void initialClazzListBlockListFlow(FlowContext flowContext){
        flowContext.executeFlowList(new SetClazzListBlockContextListFlow());
    }

    private void setDatabaseTableListBlockOptionList(FlowContext flowContext){
        ApplicationContext applicationContext = flowContext.checkInstanceData(ApplicationContext.class);
        Map<String, DatabaseTableListBlockConfigAware> map = applicationContext.getBeansOfType(DatabaseTableListBlockConfigAware.class);

        if (map.isEmpty()) {
            return;
        }
        List<DatabaseTableListBlockOption> databaseTableListBlockOptionList = new ArrayList<>();
        for(DatabaseTableListBlockConfigAware databaseTableListBlockConfigAware:map.values()){
            DatabaseTableListBlockOption databaseTableListBlockOption = databaseTableListBlockConfigAware.getAMSBlockConfig();
            databaseTableListBlockOption.routerBlock = databaseTableListBlockConfigAware;

            String className = databaseTableListBlockConfigAware.getClass().getName();
            CheckInstance.newCheck()
                    .notNullCheck(databaseTableListBlockOption, "clazz表配置,涉及类名:["+className+"]")
                    .notEmptyCheck(databaseTableListBlockOption.projectName, "项目名称,涉及类名:["+className+"]")
                    .notEmptyCheck(databaseTableListBlockOption.displayName, "表显示名称,涉及类名:["+className+"]")
                    .notNullCheck(databaseTableListBlockOption.daoName, "数据库名称,涉及类名:["+className+"]")
                    .notNullCheck(databaseTableListBlockOption.tableName, "表名,涉及类名:["+className+"]");
            databaseTableListBlockOptionList.add(databaseTableListBlockOption);
        }
        flowContext.putContextData("databaseTableListBlockOptionList", databaseTableListBlockOptionList);

        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);
        List<QuickAMSListener> quickAMSListenerList = (List<QuickAMSListener>) flowContext.checkData("quickAMSListenerList");

        List<DatabaseTableListBlockContext> databaseTableListBlockContextList = new ArrayList<>();
        for(DatabaseTableListBlockOption databaseTableListBlockOption:databaseTableListBlockOptionList){
            DatabaseTableListBlockContext databaseTableListBlockContext = new DatabaseTableListBlockContext();
            databaseTableListBlockContext.projectName = databaseTableListBlockOption.projectName;
            databaseTableListBlockContext.displayName = databaseTableListBlockOption.displayName;
            databaseTableListBlockContext.uniqueKey = databaseTableListBlockOption.routerBlock.getBlockUniqueName();
            for(QuickAMSListener quickAMSListener:quickAMSListenerList){
                databaseTableListBlockContext.dao = quickAMSListener.getDAO(databaseTableListBlockOption.daoName);
                if(null!=databaseTableListBlockContext.dao){
                    break;
                }
            }
            Validate.notNull(databaseTableListBlockContext.dao, "数据库不存在!数据库名:"+databaseTableListBlockOption.daoName);
            databaseTableListBlockContext.entity = databaseTableListBlockContext.dao.getDatabaseEntity(databaseTableListBlockOption.tableName);
            Validate.notNull(databaseTableListBlockContext.entity, "数据库实体类不存在!表名:"+databaseTableListBlockOption.tableName);

            flowContext.startFlow(new InitialDatabaseTableListBlockContextFlow())
                    .putTemporaryInstanceData(databaseTableListBlockOption)
                    .putTemporaryInstanceData(databaseTableListBlockContext)
                    .putTemporaryInstanceData(databaseTableListBlockOption, ListBlockOption.class)
                    .putTemporaryInstanceData(databaseTableListBlockContext, ListBlockContext.class)
                    .putTemporaryInstanceData(databaseTableListBlockContext, DatabaseListBlockContext.class)
                    .execute();

            databaseTableListBlockContextList.add(databaseTableListBlockContext);
            initialAMSContext.listBlockContextList.add(databaseTableListBlockContext);
        }
        flowContext.putTemporaryData("databaseTableListBlockContextList", databaseTableListBlockContextList);
    }

    private void setEntityTableListBlockOptionList(FlowContext flowContext){
        ApplicationContext applicationContext = flowContext.checkInstanceData(ApplicationContext.class);
        Map<String, EntityTableListBlockConfigAware> map = applicationContext.getBeansOfType(EntityTableListBlockConfigAware.class);

        if(map.isEmpty()){
            return;
        }
        List<EntityTableListBlockOption> entityTableListBlockOptionList = new ArrayList<>();
        for(EntityTableListBlockConfigAware entityTableListBlockConfigAware:map.values()){
            EntityTableListBlockOption entityTableListBlockOption = entityTableListBlockConfigAware.getAMSBlockConfig();
            entityTableListBlockOption.routerBlock = entityTableListBlockConfigAware;

            String className = entityTableListBlockConfigAware.getClass().getName();
            CheckInstance.newCheck()
                    .notNullCheck(entityTableListBlockOption, "clazz表配置,涉及类名:["+className+"]")
                    .notEmptyCheck(entityTableListBlockOption.projectName, "项目名称,涉及类名:["+className+"]")
                    .notEmptyCheck(entityTableListBlockOption.displayName, "表显示名称,涉及类名:["+className+"]")
                    .notNullCheck(entityTableListBlockOption.daoName, "数据库名称,涉及类名:["+className+"]")
                    .notNullCheck(entityTableListBlockOption.entityClass, "实体类名,涉及类名:["+className+"]");
            entityTableListBlockOptionList.add(entityTableListBlockOption);
        }
        flowContext.putContextData("entityTableListBlockOptionList", entityTableListBlockOptionList);

        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);
        List<QuickAMSListener> quickAMSListenerList = (List<QuickAMSListener>) flowContext.checkData("quickAMSListenerList");

        List<EntityTableListBlockContext> entityTableListBlockContextList = new ArrayList<>();
        for(EntityTableListBlockOption entityTableListBlockOption:entityTableListBlockOptionList){
            EntityTableListBlockContext entityTableListBlockContext = new EntityTableListBlockContext();
            entityTableListBlockContext.projectName = entityTableListBlockOption.projectName;
            entityTableListBlockContext.displayName = entityTableListBlockOption.displayName;
            entityTableListBlockContext.uniqueKey = entityTableListBlockOption.routerBlock.getBlockUniqueName();
            for(QuickAMSListener quickAMSListener:quickAMSListenerList){
                entityTableListBlockContext.dao = quickAMSListener.getDAO(entityTableListBlockOption.daoName);
                if(null!=entityTableListBlockContext.dao){
                    break;
                }
            }
            Validate.notNull(entityTableListBlockContext.dao, "数据库不存在!数据库名:"+entityTableListBlockOption.daoName);
            entityTableListBlockContext.entity = entityTableListBlockContext.dao.getEntity(entityTableListBlockOption.entityClass);
            Validate.notNull(entityTableListBlockContext.entity, "实体类不存在!实体类名:"+entityTableListBlockOption.entityClass.getName());

            flowContext.startFlow(new InitialEntityTableListBlockContextFlow())
                    .putTemporaryInstanceData(entityTableListBlockOption)
                    .putTemporaryInstanceData(entityTableListBlockContext)
                    .putTemporaryInstanceData(entityTableListBlockOption, ListBlockOption.class)
                    .putTemporaryInstanceData(entityTableListBlockOption, DatabaseTableListBlockOption.class)
                    .putTemporaryInstanceData(entityTableListBlockContext, ListBlockContext.class)
                    .putTemporaryInstanceData(entityTableListBlockContext, DatabaseListBlockContext.class)
                    .execute();

            entityTableListBlockContextList.add(entityTableListBlockContext);
            initialAMSContext.listBlockContextList.add(entityTableListBlockContext);
        }
        flowContext.putTemporaryData("entityTableListBlockContextList", entityTableListBlockContextList);
    }

    private void initialFormBlockList(FlowContext flowContext){
        ApplicationContext applicationContext = flowContext.checkInstanceData(ApplicationContext.class);
        Map<String, FormBlockConfigAware> map = applicationContext.getBeansOfType(FormBlockConfigAware.class);

        if(map.isEmpty()){
            return;
        }
        List<FormBlockOption> formBlockOptionList = new ArrayList<>();
        for(FormBlockConfigAware blockConfigAware : map.values()){
            FormBlockOption formBlockOption = blockConfigAware.getAMSBlockConfig();
            formBlockOption.routerBlock = blockConfigAware;

            String className = blockConfigAware.getClass().getName();
            CheckInstance.newCheck()
                    .notNullCheck(formBlockOption, "clazz表配置,涉及类名:["+className+"]")
                    .notEmptyCheck(formBlockOption.projectName, "项目名称,涉及类名:["+className+"]")
                    .notEmptyCheck(formBlockOption.displayName, "表显示名称,涉及类名:["+className+"]")
                    .notNullCheck(formBlockOption.formClass, "表单实体类,涉及类名:["+className+"]");
            formBlockOptionList.add(formBlockOption);
        }
        flowContext.putTemporaryData("formBlockOptionList", formBlockOptionList);

        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);

        List<FormBlockContext> formBlockContextList = new ArrayList<>();
        for(FormBlockOption formBlockOption:formBlockOptionList){
            FormBlockContext formBlockContext = new FormBlockContext();

            flowContext.putTemporaryInstanceData(formBlockOption)
                    .putTemporaryInstanceData(formBlockContext)
                    .putTemporaryInstanceData(formBlockOption, BlockOption.class)
                    .putTemporaryInstanceData(formBlockContext, BlockContext.class);
            flowContext.executeFlowList(new SetBlockContextFieldValueFlow());

            flowContext.startFlow(new SetClazzListBlockFieldsFlow())
                    .putCurrentCompositeFlowData("entityClass", formBlockOption.formClass)
                    .putCurrentCompositeFlowData("amsFieldOptionList", formBlockContext.responseFields)
                    .execute();

            formBlockContext.formClass = formBlockOption.formClass;
            formBlockContext.apiPrefix = "formBlock/"+formBlockContext.projectName+"/"+formBlockContext.formClass.getSimpleName();
            formBlockContext.remoteSelectList.addAll(formBlockOption.remoteSelectList);
            flowContext.startFlow(new SetBlockOperationCommonFlow())
                    .putCurrentCompositeFlowData("blockOperationList", formBlockOption.formBlockHandlerBlockOperationList)
                    .putCurrentCompositeFlowData("blockOperationContextList", formBlockContext.blockOperationContextList)
                    .execute();

            formBlockContextList.add(formBlockContext);
            initialAMSContext.formBlockContextList.add(formBlockContext);
        }
    }

    private void setAMSRouterMenuArrayFlow(FlowContext flowContext){
        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);
        List<QuickAMSListener> quickAMSListenerList = (List<QuickAMSListener>) flowContext.checkData("quickAMSListenerList");

        RouterBlockBuilder routerBlockBuilder = RouterBlockBuilder.newInstance();
        for(QuickAMSListener quickAMSListener:quickAMSListenerList){
            quickAMSListener.addRouterBlockArray(routerBlockBuilder);
        }
        initialAMSContext.routerArray = routerBlockBuilder.build();
    }

}
