function LoadFormBlockFlow(context){
    const formBlockContextList = quickams.checkData(context, "formBlockContextList");

    for(let i=0;i<formBlockContextList.length;i++){
        quickams.putData(context, "formBlockContext", formBlockContextList[i]);

        SetFormBlockObjectFlow(context);
        SetFormBlockInitialBlockActionFlow(context);
        SetFormBlockFieldsFlow(context);
        SetFormBlockOperationButtonFlow(context);

        const formBlockName = formBlockContextList[i]["uniqueKey"];
        const formBlock = quickams.checkData(context, "formBlock");
        ams.block(formBlockName, formBlock);
        quickams.removeData(context, "formBlock");

        if(context.debug){
            console.log("初始化formBlock:"+formBlockName, formBlock);
        }
    }

    function SetFormBlockObjectFlow(context){
        let formBlock = {
            "resource": {},
            "type": "form",
            "ctx": "edit",
            "events": {},
            "operations": {},
            "actions":{},
        };

        quickams.putData(context, "formBlock", formBlock);
    }

    function SetFormBlockInitialBlockActionFlow(context){
        const formBlockContext = quickams.checkData(context, "formBlockContext");
        const formBlock = quickams.checkData(context, "formBlock");

        formBlock["events"]["init"] = "initialForm";

        formBlock["actions"]["initialForm"] = function(){
            const routerPushKey = formBlockContext["uniqueKey"]+"_routerPushData";
            const formBlockRouterPushDataString = localStorage.getItem(routerPushKey);
            const formBlockRouterPushData = JSON.parse(formBlockRouterPushDataString);

            for(let prop in formBlockRouterPushData){
                this.$set(this["data"], prop, formBlockRouterPushData[prop]);
            }
            localStorage.removeItem(routerPushKey);
        };
    }

    function SetFormBlockFieldsFlow(context){
        const formBlockContext = quickams.checkData(context, "formBlockContext");
        const formBlock = quickams.checkData(context, "formBlock");

        const responseFields = formBlockContext["responseFields"];

        let fields = {};
        for(let i=0;i<responseFields.length;i++){
            const responseField = responseFields[i];
            quickams.putData(context, "fieldContext", responseField);
            if(responseField["label"].indexOf("(")>0){
                SetSelectResourceFieldFlow(context);
            }else{
                SetGeneralResourceFieldFlow(context);
            }
            const resourceField = quickams.useData(context, "resourceField");
            fields[responseField["name"]] = resourceField;
        }
        formBlock["resource"]["fields"] = fields;
    }

    function SetFormBlockOperationButtonFlow(context){
        const formBlockContext = quickams.checkData(context, "formBlockContext");

        const blockOperationContextList = formBlockContext["blockOperationContextList"];
        for(let i=0;i<blockOperationContextList.length;i++){
            const formBlockOperationContext = blockOperationContextList[i];
            quickams.putData(context, "formBlockOperationContext", formBlockOperationContext);
            quickams.putData(context, "index", i);
            SetFormBlockOperationRequestButtonFlow(context);
        }
        quickams.removeData(context, "index");

    }
}