function SetListBlockRemoteSelectFlow(context){
    const listBlockContext = quickams.checkData(context, "listBlockContext");

    const remoteSelectList = listBlockContext["listBlockContextOption"]["remoteSelectList"];

    for(let i=0;i<remoteSelectList.length;i++){
        const remoteSelect = remoteSelectList[i];
        quickams.putData(context, "remoteSelect", remoteSelect);

        setSolidSelect(context);
        setDynamicSelect(context);

        quickams.removeData(context,"remoteSelect");
    }

    function setSolidSelect(context){
        const remoteSelect = quickams.checkData(context, "remoteSelect");
        if(null==remoteSelect["options"]){
            return;
        }
        const listBlock = quickams.checkData(context, "listBlock");

        let operation = {
            "type": "field",
            "label": remoteSelect["label"],
            "slot": "searchs",
            "field": {
                "type": "select",
                "props": {
                    "placeholder": "请选择"+remoteSelect["label"],
                    "clearable": true,
                    "multiple": false,
                    "options": remoteSelect["options"]
                },
                "default": remoteSelect["defaultValue"]
            }
        };
        if(remoteSelect["cascade"]){
            operation["field"]["type"] = "cascader";
        }
        listBlock["operations"][remoteSelect["name"]] = operation;
    }

    function setDynamicSelect(context){
        const remoteSelect = quickams.checkData(context, "remoteSelect");
        if(null!=remoteSelect["options"]){
            return;
        }
        const listBlock = quickams.checkData(context, "listBlock");

        let operation = {
            "type": "field",
            "label": remoteSelect["label"],
            "slot": "searchs",
            "field": {
                "BASE": "SELECT_REMOTE",
                "type": "select",
                "info": remoteSelect["label"],
                "props": {
                    "placeholder": "请选择"+remoteSelect["label"],
                    "clearable": true,
                    "multiple": false
                },
                "remoteConfig": {
                    "dataPath" : "data",
                    "action": "/ams/api/remoteSelect/"
                        + listBlockContext["uniqueKey"]
                        + "?remoteLabel="+remoteSelect["label"]
                        + (null!=remoteSelect["extraParameter"]?"&"+remoteSelect["extraParameter"]:""),
                    "transform": function($field, data){
                        //option格式需为{label:xx,value:xx}
                        return data;
                    },
                    "isCache": false,
                    "isInitEmpty": false,
                    "isInitRemoteOptions": true,
                    "isLock": true,
                    "isMiniBackfill": true,
                    "labelKey": "name",
                    "queryKey": "name",
                },
                "default": remoteSelect["defaultValue"]
            }
        };
        listBlock["operations"][remoteSelect["name"]] = operation;
    }
}