function SetListBlockRouterPushFlow(context){
    const listBlockContext = quickams.checkData(context, "listBlockContext");
    const listBlock = quickams.checkData(context, "listBlock");

    const blockRouterPushList = listBlockContext["listBlockContextOption"]["blockRouterPushList"];
    for(let i=0;i<blockRouterPushList.length;i++){
        context["blockRouterPush"] = blockRouterPushList[i];
        context["index"] = i;
        setOperation(context);
        setAction(context);
    }

    function setOperation(context){
        const blockRouterPush = quickams.checkData(context, "blockRouterPush");
        const index = quickams.checkData(context, "index");

        let operation = {
            "type": "button",
            "label": blockRouterPush["label"],
            "props":{
                "type": "primary",
            },
            "event": "routerPushAction"+index
        };
        listBlock["operations"]["routerPushButton"+index] = operation;
    }

    function setAction(context){
        const blockRouterPush = quickams.checkData(context, "blockRouterPush");
        const index = quickams.checkData(context, "index");

        const sourceTargetFieldNameMap = blockRouterPush["sourceTargetFieldNameMap"];
        let action = function(params){
            const row = params.$prevReturn;
            let query = {};
            if(null!=sourceTargetFieldNameMap&&Object.keys(sourceTargetFieldNameMap).length>0){
                for(let sourceFieldName in sourceTargetFieldNameMap){
                    let targetFieldName = sourceTargetFieldNameMap[sourceFieldName];
                    let targetValue = row[sourceFieldName];
                    query[targetFieldName] = targetValue;
                }
            }
            const itemName = blockRouterPush["uniqueKey"]+"_routerPushData";
            localStorage.setItem(itemName, JSON.stringify(query));

            this.callAction("routerPush", {
                "name": blockRouterPush["name"],
                // "query": query
            });
        };

        listBlock["actions"]["routerPushAction"+index] = action;
    }

}