function SetGeneralResourceFieldFlow(context){
    const fieldContext = quickams.checkData(context, "fieldContext");

    const label = quickams.checkData(fieldContext, "label");
    const amsType = quickams.checkData(fieldContext, "amsType");
    const info = quickams.getData(fieldContext, "info");

    let resourceField = {
        "label": label,
        "info": info,
        "type": amsType,
        "props": {
            "placeholder": "请输入"+label,
            "clearable": true,
        },
        "default": fieldContext["defaultValue"]
    };
    for(let prop in fieldContext["props"]){
        resourceField["props"][prop] = fieldContext["props"][prop];
    }
    context["resourceField"] = resourceField;
}