

function SetupResourceBlockFlow(context){
    SetResourceBlockAPIFlow(context);
    SetResourceBlockResponseFieldsFlow(context);

    function SetResourceBlockAPIFlow(context){
        let listBlockContext = quickams.checkData(context, "listBlockContext");

        let resourceBlockContextOption = listBlockContext["resourceBlockContextOption"];

        let resourceBlock = {
            "key": resourceBlockContextOption["idField"],
            "api": {
                "prefix": "/ams/api/"+resourceBlockContextOption["apiPrefix"],
                "list": "/list",
                "create": "/create",
                "update": {
                    "method": "post",
                    "path": "/update",
                    requestDataParse(row) {
                        let jsonFieldNameList = [];
                        for(let prop in row){
                            const value = row[prop];
                            if(typeof(value)==="string"){
                                if(value.indexOf("{")===0||value.indexOf("[")===0){
                                    jsonFieldNameList.push(prop);
                                }
                            }
                        }
                        for(let i=0;i<jsonFieldNameList.length;i++){
                            const jsonFieldName = jsonFieldNameList[i];
                            row[jsonFieldName] = JSON.parse(row[jsonFieldName]);
                        }
                        return row;
                    },
                },
                "delete": "/delete"
            }
        };
        quickams.putData(context, "resourceName", listBlockContext["uniqueKey"]+"|resource");
        quickams.putData(context, "resourceBlock", resourceBlock);
    }

    function SetResourceBlockResponseFieldsFlow(context){
        const listBlockContext = quickams.checkData(context, "listBlockContext");
        const resourceBlock = quickams.checkData(context, "resourceBlock");

        const responseFields = listBlockContext["resourceBlockContextOption"]["responseFields"];

        let fields = {};
        for(let i=0;i<responseFields.length;i++){
            const responseField = responseFields[i];
            quickams.putData(context, "fieldContext", responseField);
            if(responseField["label"].indexOf("(")>0){
                SetSelectResourceFieldFlow(context);
            }else{
                SetGeneralResourceFieldFlow(context);
            }
            const resourceField = quickams.useData(context, "resourceField");
            fields[responseField["name"]] = resourceField;
        }
        resourceBlock["fields"] = fields;
    }
}