function SetListBlockCopyFieldFlow(context){
    const listBlockContext = quickams.checkData(context, "listBlockContext");
    const listBlock = quickams.checkData(context, "listBlock");
    const resourceBlock = quickams.checkData(context, "resourceBlock");

    const copyFieldCommentMap = listBlockContext["listBlockContextOption"]["copyFieldCommentMap"];

    let index = 0;
    for(let prop in copyFieldCommentMap){
        listBlock["operations"]["copyField"+index] = {
            "type": "button",
            "props": {
                "type": "primary",
            },
            "label": copyFieldCommentMap[prop],
            "event": "copyField:"+prop,
            "show": function(row){
                let fieldNames = [];
                if(prop.indexOf(",")>0){
                    fieldNames = prop.split(",", -1);
                }else{
                    fieldNames.push(prop);
                }
                let hasValue = false;
                for(let i=0;i<fieldNames.length;i++){
                    if(null!=row[fieldNames[i]]&&""!==row[fieldNames[i]]){
                        hasValue = true;
                        break;
                    }
                }
                return hasValue;
            }
        };
        index++;
    }

    listBlock["actions"]["copyField"] = function(params){
        let row = params.$prevReturn;
        let arg = params["$arg"];

        let fieldNames = [];
        if(arg.indexOf(",")>0){
            fieldNames = arg.split(",", -1);
        }else{
            fieldNames.push(arg);
        }

        let content = "";
        for(let i=0;i<fieldNames.length;i++){
            let val = row[fieldNames[i]];
            if (typeof (val) == "object" || typeof (val) == "array") {
                val = JSON.stringify(val);
            }
            const label = resourceBlock["fields"][fieldNames[i]]["label"];
            content += label+":\r\n"+val+"\r\n\r\n";
        }
        quickams["setClipBoard"]({
            "value": content
        });
        this.$message.success("信息已复制到剪贴板");
    }
}