function SetListBlockOperationFieldTabDialogButtonFlow(context){
    setTabBlock(context);
    setOperation(context);

    function setTabBlock(context){
        const blockOperationContext = quickams.checkData(context, "blockOperationContext");
        const resourceBlock = quickams.checkData(context, "resourceBlock");
        const listBlock = quickams.checkData(context, "listBlock");
        const index = quickams.checkData(context, "index");
        const listBlockName = quickams.checkData(context, "listBlockName");

        let dialogContentBlock = {
            "type": "tabs",
            "options": {},
            "props": {
                "type": "border-card"
            },
            "blocks": {}
        };

        const fieldNames = blockOperationContext["fieldNames"];
        for(let i=0;i<fieldNames.length;i++) {
            const fieldName = fieldNames[i];
            dialogContentBlock["options"][fieldName] = resourceBlock["fields"][fieldName]["label"];
            dialogContentBlock["blocks"][fieldName] = {
                "type": "component",
                "options": {
                    "is": "pre",
                    "html": "{}",
                },
                "style": {
                    "height": "500px",
                    "max-height": "500px",
                    "overflow-y": "auto"
                },
                "data": {
                    "fieldName": fieldName
                },
                "events": {
                    "init": "setData"
                },
                "actions": {
                    "setData": function(params){
                        const row = params.$prevReturn;
                        const actionFieldName = this["data"]["fieldName"];
                        let fieldValue = row[actionFieldName];
                        if (typeof (fieldValue) == "object" || typeof (fieldValue) == "array") {
                            fieldValue = JSON.stringify(fieldValue, null, '\t');
                        }
                        fieldValue = fieldValue.replaceAll("\r\n","<br/>");
                        this["block"]["options"]["html"] = fieldValue;
                    }
                }
            };
        }

        listBlock["blocks"][listBlockName+"_dialog"+index] = {
            "type": "dialog",
            "props": {
                "append-to-body": true
            },
            "data": {
                "title": blockOperationContext["label"]
            },
            "blocks": {}
        };
        listBlock["blocks"][listBlockName+"_dialog"+index]["blocks"][listBlockName+"_dialogContent"+index] = dialogContentBlock;
    }

    function setOperation(context){
        const blockOperationContext = quickams.checkData(context, "blockOperationContext");
        const listBlock = quickams.checkData(context, "listBlock");
        const index = quickams.checkData(context, "index");
        const listBlockName = quickams.checkData(context, "listBlockName");

        let operation = {
            "type": "button",
            "label": blockOperationContext["label"],
            "props":{
                "type": blockOperationContext["buttonType"],
            },
            "event": listBlockName+"_dialog"+index+".show"
        };
        quickams.putData(context, "operationButton", operation);
        SetOperationShowFunctionFlow(context);

        listBlock["operations"]["operationButton"+index] = operation;
    }

}