class QueryList {
    constructor(list) {
        this.list = list;
    }
    addQuery(fieldName, fieldValue) {
        if(!this.hasOwnProperty("queryFieldMap")){
            this.queryFieldMap = {};
        }
        this["queryFieldMap"][fieldName] = fieldValue;
        return this;
    }
    getOne(){
        let filterList = this.getList();
        if(filterList.length>0){
            return filterList[0];
        }else{
            return null;
        }
    }
    getList(){
        let filterList = [];
        for(let i=0;i<this.list.length;i++){
            const obj = this.list[i];
            let addToList = true;
            for(let prop in this["queryFieldMap"]){
                if(obj[prop]!==this["queryFieldMap"][prop]){
                    addToList = false;
                    break;
                }
            }
            if(addToList){
                filterList.push(obj);
            }
        }
        return filterList;
    }
}