let quickams = {};
function SetQuickAMSDataFlow(context){
    quickams["getData"] = function(context,fieldName){
        let value = context[fieldName];
        return value;
    }

    quickams["getData"] = function(context,fieldName,defaultValue){
        let value = context[fieldName];
        if(null==value||(typeof value)=="undefined"){
            return defaultValue;
        }else{
            return value;
        }
    }

    quickams["checkData"] = function(context,fieldName){
        let value = context[fieldName];
        if(null==value||""===value){
            console.error("字段["+fieldName+"]的值为空");
        }
        return value;
    }

    quickams["useData"] = function(context,fieldName){
        let value = quickams["getData"](context,fieldName);
        delete context[fieldName];
        return value;
    }

    quickams["putData"] = function(context,fieldName,fieldValue){
        context[fieldName] = fieldValue;
    }

    quickams["removeData"] = function(context,fieldName){
        delete context[fieldName];
    }

    quickams["setClipBoard"] = function(context){
        let value = quickams.checkData(context, "value");
        let plainValue = quickams.getData(context, "plainValue", false);

        if(plainValue){
            value = value.replace("\r\n","\n");
        }

        let e = document.getElementById("clipboard");
        e.value = value;
        e.select();
        document.execCommand("copy");
    }
}