/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.util.MigrateOption;
import cn.schoolwow.quickdao.domain.util.TableStructureSynchronizedOption;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAOUtils {
    private static Logger logger = LoggerFactory.getLogger(DAOUtils.class);

    public static void tableStructureSynchronized(TableStructureSynchronizedOption option) {
        if (null == option.source) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u6e90\u6570\u636e\u5e93!");
        }
        if (null == option.target) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u76ee\u6807\u6570\u636e\u5e93!");
        }
        List<Entity> sourceEntityList = option.source.getDbEntityList();
        for (Entity sourceEntity : sourceEntityList) {
            Entity targetEntity = option.target.getDbEntity(sourceEntity.tableName);
            if (null == targetEntity) {
                if (null != option.createTablePredicate && !option.createTablePredicate.test(sourceEntity)) continue;
                option.target.create(sourceEntity);
                continue;
            }
            for (Property property : sourceEntity.properties) {
                if (!targetEntity.properties.stream().noneMatch(property1 -> property1.column.equalsIgnoreCase(property.column)) || null != option.createPropertyPredicate && !option.createPropertyPredicate.test(property)) continue;
                option.target.createColumn(sourceEntity.tableName, property);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrate(MigrateOption migrateOption) {
        if (null == migrateOption.source) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u6e90\u6570\u636e\u5e93!");
        }
        if (null == migrateOption.target) {
            throw new IllegalArgumentException("\u8bf7\u6307\u5b9a\u8fc1\u79fb\u76ee\u6807\u6570\u636e\u5e93!");
        }
        List<Entity> sourceEntityList = migrateOption.source.getDbEntityList();
        if (null != migrateOption.tableFilter) {
            sourceEntityList = sourceEntityList.stream().filter(migrateOption.tableFilter).collect(Collectors.toList());
        }
        if (null == sourceEntityList || sourceEntityList.isEmpty()) {
            logger.warn("[\u6570\u636e\u5e93\u8fc1\u79fb]\u5f53\u524d\u8fc1\u79fb\u6e90\u6570\u636e\u5e93\u8868\u5217\u8868\u4e3a\u7a7a!");
            return;
        }
        migrateOption.target.enableForeignConstraintCheck(false);
        try {
            for (Entity sourceEntity : sourceEntityList) {
                Entity targetEntity = sourceEntity.clone();
                if (null != migrateOption.tableConsumer) {
                    migrateOption.tableConsumer.accept(sourceEntity, targetEntity);
                }
                if (migrateOption.target.hasTable(targetEntity.tableName)) {
                    logger.debug("[\u6570\u636e\u8fc1\u79fb]\u5220\u9664\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", (Object)targetEntity.tableName);
                    migrateOption.target.dropTable(targetEntity.tableName);
                }
                logger.debug("[\u6570\u636e\u8fc1\u79fb]\u521b\u5efa\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", (Object)targetEntity.tableName);
                targetEntity.escapeTableName = migrateOption.target.getQuickDAOConfig().database.escape(targetEntity.tableName);
                migrateOption.target.create(targetEntity);
                long count = migrateOption.source.query(sourceEntity.tableName).execute().count();
                int effect = 0;
                if (count > 0L) {
                    long totalPage = count / (long)migrateOption.batchCount + 1L;
                    logger.info("[\u6570\u636e\u8fc1\u79fb]\u51c6\u5907\u8fc1\u79fb\u6570\u636e\u5e93\u8868,\u6e90\u8868:{},\u603b\u8bb0\u5f55\u6570:{},\u8fc1\u79fb\u76ee\u6807\u8868:{}", new Object[]{sourceEntity.tableName, count, targetEntity.tableName});
                    int i = 1;
                    while ((long)i <= totalPage) {
                        logger.debug("[\u6570\u636e\u8fc1\u79fb]\u51c6\u5907\u4f20\u8f93\u7b2c{}/{}\u9875\u6570\u636e,\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", new Object[]{i, totalPage, sourceEntity.tableName, targetEntity.tableName});
                        JSONArray array = migrateOption.source.query(sourceEntity.tableName).page(i, migrateOption.batchCount).execute().getArray();
                        logger.debug("[\u6570\u636e\u8fc1\u79fb]\u7b2c{}/{}\u9875\u6570\u636e\u4f20\u8f93\u5b8c\u6bd5,\u8fc1\u79fb\u5b8c\u6210\u8bb0\u5f55\u6570:{}/{},\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", new Object[]{i, totalPage, effect += migrateOption.target.query(targetEntity.tableName).addInsert(array).execute().insertBatch(), count, sourceEntity.tableName, targetEntity.tableName});
                        ++i;
                    }
                }
                logger.info("[\u6570\u636e\u8fc1\u79fb]\u8868\u6570\u636e\u8fc1\u79fb\u5b8c\u6bd5,\u8fc1\u79fb\u5b8c\u6210\u8bb0\u5f55\u6570:{}/{},\u6e90\u6570\u636e\u5e93\u8868:{},\u76ee\u6807\u6570\u636e\u5e93\u8868:{}", new Object[]{effect, count, sourceEntity.tableName, targetEntity.tableName});
            }
        }
        finally {
            migrateOption.target.enableForeignConstraintCheck(true);
        }
    }
}

