/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.dao.DAO;
import cn.schoolwow.quickdao.dao.DAOInvocationHandler;
import cn.schoolwow.quickdao.domain.ColumnTypeMapping;
import cn.schoolwow.quickdao.domain.Database;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.generator.IDGenerator;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.handler.DefaultEntityHandler;
import cn.schoolwow.quickdao.handler.DefaultTableDefiner;
import cn.schoolwow.quickdao.handler.TableDefiner;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickDAO {
    private Logger logger = LoggerFactory.getLogger(QuickDAO.class);
    private QuickDAOConfig quickDAOConfig = new QuickDAOConfig();

    public static QuickDAO newInstance() {
        return new QuickDAO();
    }

    public QuickDAO() {
        DefaultEntityHandler entityHandler = new DefaultEntityHandler(this.quickDAOConfig);
        this.quickDAOConfig.entityHandler = entityHandler;
    }

    public QuickDAO dataSource(DataSource dataSource) {
        this.quickDAOConfig.dataSource = dataSource;
        try {
            Connection connection = this.quickDAOConfig.dataSource.getConnection();
            connection.setAutoCommit(false);
            String jdbcUrl = connection.getMetaData().getURL();
            this.quickDAOConfig.database = Database.getDatabaseByJdbcUrl(jdbcUrl);
            this.logger.info("[\u6570\u636e\u6e90]\u7c7b\u578b:{},\u5730\u5740:{}", (Object)this.quickDAOConfig.database.name(), (Object)jdbcUrl);
            connection.close();
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        return this;
    }

    public QuickDAO packageName(String packageName) {
        this.quickDAOConfig.packageNameMap.put(packageName, "");
        return this;
    }

    public QuickDAO packageName(String packageName, String prefix) {
        this.quickDAOConfig.packageNameMap.put(packageName, prefix + "_");
        return this;
    }

    public QuickDAO entity(Class ... entityClasses) {
        for (Class entityClass : entityClasses) {
            this.quickDAOConfig.entityClassMap.put(entityClass, "");
        }
        return this;
    }

    public QuickDAO entity(Class entityClass, String prefix) {
        this.quickDAOConfig.entityClassMap.put(entityClass, prefix);
        return this;
    }

    public QuickDAO ignorePackageName(String ignorePackageName) {
        if (this.quickDAOConfig.ignorePackageNameList == null) {
            this.quickDAOConfig.ignorePackageNameList = new ArrayList<String>();
        }
        this.quickDAOConfig.ignorePackageNameList.add(ignorePackageName);
        return this;
    }

    public QuickDAO ignoreClass(Class ignoreClass) {
        if (this.quickDAOConfig.ignoreClassList == null) {
            this.quickDAOConfig.ignoreClassList = new ArrayList<Class>();
        }
        this.quickDAOConfig.ignoreClassList.add(ignoreClass);
        return this;
    }

    public QuickDAO filter(Predicate<Class> predicate) {
        this.quickDAOConfig.predicate = predicate;
        return this;
    }

    public QuickDAO foreignKey(boolean openForeignKey) {
        this.quickDAOConfig.openForeignKey = openForeignKey;
        return this;
    }

    public QuickDAO autoCreateTable(boolean autoCreateTable) {
        this.quickDAOConfig.autoCreateTable = autoCreateTable;
        return this;
    }

    public QuickDAO autoCreateProperty(boolean autoCreateProperty) {
        this.quickDAOConfig.autoCreateProperty = autoCreateProperty;
        return this;
    }

    public QuickDAO idStrategy(IdStrategy idStrategy) {
        this.quickDAOConfig.idStrategy = idStrategy;
        return this;
    }

    public QuickDAO idGenerator(IDGenerator idGenerator) {
        this.quickDAOConfig.idGenerator = idGenerator;
        return this;
    }

    public QuickDAO engine(String engine) {
        this.quickDAOConfig.engine = engine;
        return this;
    }

    public QuickDAO charset(String charset) {
        this.quickDAOConfig.charset = charset;
        return this;
    }

    public QuickDAO columnTypeMapping(ColumnTypeMapping columnTypeMapping) {
        this.quickDAOConfig.columnTypeMapping = columnTypeMapping;
        return this;
    }

    public QuickDAO perBatchCommit(int perBatchCommit) {
        this.quickDAOConfig.perBatchCommit = perBatchCommit;
        return this;
    }

    public QuickDAO insertColumnValueFunction(Function<Property, Object> insertColumnValueFunction) {
        this.quickDAOConfig.insertColumnValueFunction = insertColumnValueFunction;
        return this;
    }

    public QuickDAO updateColumnValueFunction(Function<Property, Object> updateColumnValueFunction) {
        this.quickDAOConfig.updateColumnValueFunction = updateColumnValueFunction;
        return this;
    }

    public QuickDAO lazyLoad(boolean lazyLoad) {
        this.quickDAOConfig.lazyLoad = lazyLoad;
        return this;
    }

    public TableDefiner define(Class clazz) {
        if (this.quickDAOConfig.entityMap.isEmpty()) {
            try {
                this.quickDAOConfig.entityHandler.getEntityMap();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null == this.quickDAOConfig.dataSource) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        if (null == entity) {
            throw new IllegalArgumentException("\u672a\u626b\u63cf\u6307\u5b9a\u7c7b\u4fe1\u606f!\u7c7b\u540d:" + clazz.getName());
        }
        return new DefaultTableDefiner(entity, this);
    }

    public DAO build() {
        DAO daoProxy;
        if (null == this.quickDAOConfig.database) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528dataSource\u65b9\u6cd5\u914d\u7f6e\u6570\u636e\u6e90!");
        }
        if (this.quickDAOConfig.entityMap.isEmpty()) {
            try {
                this.quickDAOConfig.entityHandler.getEntityMap();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DAOInvocationHandler daoInvocationHandler = new DAOInvocationHandler(this.quickDAOConfig);
        this.quickDAOConfig.dao = daoProxy = (DAO)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DAO.class}, (InvocationHandler)daoInvocationHandler);
        if (!this.quickDAOConfig.lazyLoad) {
            daoProxy.automaticCreateTableAndColumn();
            this.quickDAOConfig.initialized = true;
        } else {
            this.logger.info("[\u5f00\u542f\u61d2\u52a0\u8f7d\u529f\u80fd]");
        }
        return daoProxy;
    }
}

