/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder;

import cn.schoolwow.quickdao.builder.SQLBuilder;
import cn.schoolwow.quickdao.domain.ConnectionExecutor;
import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSQLBuilder
implements SQLBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractSQLBuilder.class);
    protected static final String PLACEHOLDER = "** NOT SPECIFIED **";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat simpleTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public QuickDAOConfig quickDAOConfig;
    public volatile ConnectionExecutor connectionExecutor;

    public AbstractSQLBuilder(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public ConnectionExecutorItem selectCountById(Object instance) throws Exception {
        String key = "selectCountById_" + instance.getClass().getName() + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getName();
        Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            builder.append("select count(1) from " + entity.escapeTableName + " where ");
            builder.append(this.quickDAOConfig.database.escape(entity.id.column) + " = " + (null == entity.id.function ? "?" : entity.id.function) + " ");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.sqlCache.get(key);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636eid\u67e5\u8be2", sql);
        Field field = instance.getClass().getDeclaredField(entity.id.name);
        field.setAccessible(true);
        Object value = field.get(instance);
        connectionExecutorItem.preparedStatement.setObject(1, value);
        connectionExecutorItem.sql = field.getType().getName().equals("java.lang.String") ? sql.replace("?", value == null ? "" : "'" + value.toString() + "'") : sql.replace("?", value == null ? "" : value.toString());
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem selectCountByUniqueKey(Object instance) throws Exception {
        String key = "selectCountByUniqueKey_" + instance.getClass().getName() + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getName();
        Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            builder.append("select count(1) from " + entity.escapeTableName + " where ");
            for (Property property : entity.uniqueProperties) {
                builder.append(this.quickDAOConfig.database.escape(property.column) + "= " + (null == property.function ? "?" : property.function) + " and ");
            }
            builder.delete(builder.length() - 5, builder.length());
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.sqlCache.get(key);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u67e5\u8be2", sql);
        StringBuilder builder = new StringBuilder(sql.replace("?", PLACEHOLDER));
        int parameterIndex = 1;
        for (Property property : entity.uniqueProperties) {
            this.setParameter(instance, property, connectionExecutorItem.preparedStatement, parameterIndex, builder);
            ++parameterIndex;
        }
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    protected void setParameter(Object parameter, PreparedStatement ps, int parameterIndex, StringBuilder sqlBuilder) throws SQLException {
        String parameterSQL = this.setPrepareStatementParameter(parameter, ps, parameterIndex);
        AbstractSQLBuilder.replaceFirst(sqlBuilder, parameterSQL);
    }

    protected void setParameter(Object instance, Property property, PreparedStatement ps, int parameterIndex, StringBuilder sqlBuilder) throws Exception {
        Field field = this.getFieldFromInstance(instance, property);
        String parameterSQL = this.setPrepareStatementParameter(field.get(instance), ps, parameterIndex);
        AbstractSQLBuilder.replaceFirst(sqlBuilder, parameterSQL);
    }

    protected Field getFieldFromInstance(Object instance, Property property) {
        Field field = null;
        block0: for (Class<?> tempClass = instance.getClass(); null == field && null != tempClass; tempClass = tempClass.getSuperclass()) {
            Field[] fields;
            for (Field field1 : fields = tempClass.getDeclaredFields()) {
                if (!field1.getName().equals(property.name)) continue;
                field = field1;
                continue block0;
            }
        }
        if (null == field) {
            throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u5b58\u5728!\u5b57\u6bb5\u540d:" + property.name + ",\u7c7b\u540d:" + instance.getClass().getName());
        }
        field.setAccessible(true);
        return field;
    }

    protected String setPrepareStatementParameter(Object parameter, PreparedStatement ps, int parameterIndex) throws SQLException {
        if (null == parameter) {
            ps.setObject(parameterIndex, null);
            return "null";
        }
        String parameterSQL = parameter.toString();
        switch (parameter.getClass().getName()) {
            case "byte": {
                ps.setByte(parameterIndex, (Byte)parameter);
                break;
            }
            case "[B": {
                ps.setBytes(parameterIndex, (byte[])parameter);
                break;
            }
            case "boolean": {
                boolean value = (Boolean)parameter;
                ps.setBoolean(parameterIndex, value);
                parameterSQL = value ? "1" : "0";
                break;
            }
            case "short": {
                ps.setShort(parameterIndex, (Short)parameter);
                break;
            }
            case "int": {
                ps.setInt(parameterIndex, (Integer)parameter);
                break;
            }
            case "float": {
                ps.setFloat(parameterIndex, ((Float)parameter).floatValue());
                break;
            }
            case "long": {
                ps.setLong(parameterIndex, (Long)parameter);
                break;
            }
            case "double": {
                ps.setDouble(parameterIndex, (Double)parameter);
                break;
            }
            case "java.lang.String": {
                ps.setString(parameterIndex, (String)parameter);
                parameterSQL = "'" + parameter.toString() + "'";
                break;
            }
            case "java.util.Date": {
                java.util.Date date = (java.util.Date)parameter;
                ps.setDate(parameterIndex, new Date(date.getTime()));
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Date": {
                Date date = (Date)parameter;
                ps.setDate(parameterIndex, (Date)parameter);
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Time": {
                Time time = (Time)parameter;
                ps.setTime(parameterIndex, time);
                parameterSQL = "'" + simpleTimeFormat.format(time) + "'";
                break;
            }
            case "java.sql.Timestamp": {
                Timestamp timestamp = (Timestamp)parameter;
                ps.setTimestamp(parameterIndex, timestamp);
                parameterSQL = "'" + simpleDateTimeFormat.format(timestamp) + "'";
                break;
            }
            case "java.time.LocalDate": {
                LocalDate localDate = (LocalDate)parameter;
                switch (this.quickDAOConfig.database) {
                    case Oracle: {
                        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
                        Date date = new Date(Date.from(zonedDateTime.toInstant()).getTime());
                        ps.setObject(parameterIndex, date);
                        break;
                    }
                    default: {
                        ps.setObject(parameterIndex, localDate);
                    }
                }
                parameterSQL = "'" + localDate.format(dateFormatter) + "'";
                break;
            }
            case "java.time.LocalDateTime": {
                LocalDateTime localDateTime = (LocalDateTime)parameter;
                switch (this.quickDAOConfig.database) {
                    case Oracle: {
                        ZoneId zoneId = ZoneId.systemDefault();
                        Instant instant = localDateTime.atZone(zoneId).toInstant();
                        Timestamp timestamp = new Timestamp(instant.toEpochMilli());
                        ps.setObject(parameterIndex, timestamp);
                        break;
                    }
                    default: {
                        ps.setObject(parameterIndex, localDateTime);
                    }
                }
                parameterSQL = "'" + localDateTime.format(dateTimeFormatter) + "'";
                break;
            }
            case "java.sql.Array": {
                ps.setArray(parameterIndex, (Array)parameter);
                break;
            }
            case "java.math.BigDecimal": {
                ps.setBigDecimal(parameterIndex, (BigDecimal)parameter);
                break;
            }
            case "java.sql.Blob": {
                ps.setBlob(parameterIndex, (Blob)parameter);
                break;
            }
            case "java.sql.Clob": {
                ps.setClob(parameterIndex, (Clob)parameter);
                break;
            }
            case "java.sql.NClob": {
                ps.setNClob(parameterIndex, (NClob)parameter);
                break;
            }
            case "java.sql.Ref": {
                ps.setRef(parameterIndex, (Ref)parameter);
                break;
            }
            case "java.net.URL": {
                ps.setURL(parameterIndex, (URL)parameter);
                break;
            }
            case "java.sql.RowId": {
                ps.setRowId(parameterIndex, (RowId)parameter);
                break;
            }
            case "java.sql.SQLXML": {
                ps.setSQLXML(parameterIndex, (SQLXML)parameter);
                break;
            }
            case "java.io.InputStream": {
                ps.setBinaryStream(parameterIndex, (InputStream)parameter);
                break;
            }
            case "java.io.Reader": {
                ps.setCharacterStream(parameterIndex, (Reader)parameter);
                break;
            }
            default: {
                try {
                    ps.setObject(parameterIndex, parameter);
                    break;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return parameterSQL;
    }

    protected static void replaceFirst(StringBuilder sqlBuilder, String parameter) {
        int indexOf = sqlBuilder.indexOf(PLACEHOLDER);
        if (indexOf >= 0) {
            sqlBuilder.replace(indexOf, indexOf + PLACEHOLDER.length(), parameter);
        }
    }
}

