/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.dcl;

import cn.schoolwow.quickdao.builder.dcl.AbstractDCLBuilder;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.dcl.DataBaseUser;
import cn.schoolwow.quickdao.domain.dcl.GrantOption;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PostgreDCLBuilder
extends AbstractDCLBuilder {
    public PostgreDCLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public List<String> getUserNameList() throws SQLException {
        String sql = "select usename from pg_user;";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u7528\u6237\u5217\u8868", sql);
        ArrayList<String> userNameList = new ArrayList<String>();
        while (resultSet.next()) {
            userNameList.add(resultSet.getString(1));
        }
        resultSet.close();
        return userNameList;
    }

    @Override
    public void createUser(DataBaseUser dataBaseUser) throws SQLException {
        String sql = "create user " + dataBaseUser.username + " with password '" + dataBaseUser.password + "';";
        this.connectionExecutor.executeUpdate("\u521b\u5efa\u7528\u6237", sql);
    }

    @Override
    public void modifyPassword(String username, String newPassword) throws SQLException {
        String sql = "alter user " + username + " with password '" + newPassword + "';";
        this.connectionExecutor.executeUpdate("\u4fee\u6539\u5bc6\u7801", sql);
    }

    @Override
    public void deleteUser(DataBaseUser dataBaseUser) throws SQLException {
        String sql = "drop role " + dataBaseUser.username + ";";
        this.connectionExecutor.executeUpdate("\u5220\u9664\u7528\u6237", sql);
    }

    @Override
    public void grant(GrantOption grantOption) throws SQLException {
        String sql = "grant " + grantOption.privileges + " on database " + grantOption.databaseName + " to " + grantOption.dataBaseUser.username + ";";
        this.connectionExecutor.executeUpdate("\u6570\u636e\u5e93\u6388\u6743", sql);
    }

    @Override
    public void createUserAndGrant(GrantOption grantOption) throws SQLException {
        this.createUser(grantOption.dataBaseUser);
        this.grant(grantOption);
    }

    @Override
    public void revoke(GrantOption grantOption) throws SQLException {
        String sql = "revoke " + grantOption.privileges + " on database " + grantOption.databaseName + " from " + grantOption.dataBaseUser.username + ";";
        this.connectionExecutor.executeUpdate("\u6536\u56de\u6743\u9650", sql);
    }
}

