/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.ddl;

import cn.schoolwow.quickdao.builder.AbstractSQLBuilder;
import cn.schoolwow.quickdao.builder.ddl.DDLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDDLBuilder
extends AbstractSQLBuilder
implements DDLBuilder {
    protected Logger logger = LoggerFactory.getLogger(DDLBuilder.class);

    public AbstractDDLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public void getDatabaseName() throws SQLException {
    }

    @Override
    public List<Entity> getDatabaseEntity() throws SQLException {
        List<Entity> entityList = this.getEntityList();
        for (Entity entity : entityList) {
            entity.properties.clear();
        }
        this.getEntityPropertyList(entityList);
        for (Entity entity : entityList) {
            entity.indexFieldList.clear();
        }
        this.getIndex(entityList);
        return entityList;
    }

    @Override
    public abstract boolean hasTableExists(Entity var1) throws SQLException;

    @Override
    public abstract void createTable(Entity var1) throws SQLException;

    @Override
    public void createProperty(Property property) throws SQLException {
        StringBuilder createPropertyBuilder = new StringBuilder("alter table " + this.quickDAOConfig.database.escape(property.entity.tableName) + " add " + this.quickDAOConfig.database.escape(property.column) + " " + property.columnType);
        if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
            createPropertyBuilder.append(" default " + property.defaultValue);
        }
        if (property.notNull) {
            createPropertyBuilder.append(" not null");
        }
        if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
            createPropertyBuilder.append(" check " + property.escapeCheck);
        }
        if (null != property.comment) {
            createPropertyBuilder.append(" " + this.quickDAOConfig.database.comment(property.comment));
        }
        if (null != property.after) {
            createPropertyBuilder.append(" after " + this.quickDAOConfig.database.escape(property.after));
        }
        this.connectionExecutor.executeUpdate("\u6dfb\u52a0\u65b0\u5217", createPropertyBuilder.toString());
    }

    @Override
    public void alterColumn(Property property) throws SQLException {
        StringBuilder builder = new StringBuilder("alter table " + this.quickDAOConfig.database.escape(property.entity.tableName));
        builder.append(" alter column " + this.quickDAOConfig.database.escape(property.column) + " " + property.columnType);
        this.connectionExecutor.executeUpdate("\u4fee\u6539\u6570\u636e\u7c7b\u578b", builder.toString());
    }

    @Override
    public void dropColumn(Property property) throws SQLException {
        StringBuilder builder = new StringBuilder("alter table ");
        if (null != this.quickDAOConfig.databaseName) {
            builder.append(this.quickDAOConfig.database.escape(this.quickDAOConfig.databaseName) + ".");
        }
        builder.append(this.quickDAOConfig.database.escape(property.entity.tableName));
        builder.append(" drop column " + this.quickDAOConfig.database.escape(property.column));
        this.connectionExecutor.executeUpdate("\u5220\u9664\u5217", builder.toString());
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        String sql = "drop table " + this.quickDAOConfig.database.escape(tableName);
        this.connectionExecutor.executeUpdate("\u5220\u9664\u8868", sql);
    }

    @Override
    public void rebuild(Entity entity) throws SQLException {
        if (this.hasTableExists(entity)) {
            this.dropTable(entity.tableName);
        }
        this.createTable(entity);
    }

    @Override
    public abstract boolean hasIndexExists(String var1, String var2) throws SQLException;

    @Override
    public boolean hasConstraintExists(String tableName, String constraintName) throws SQLException {
        String hasConstraintExistsSQL = "select count(1) from information_schema.KEY_COLUMN_USAGE where constraint_name='" + constraintName + "'";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u5224\u65ad\u7d22\u5f15\u662f\u5426\u5b58\u5728", hasConstraintExistsSQL);
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void createIndex(IndexField indexField) throws SQLException {
        if (indexField.columns.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("create");
        switch (indexField.indexType) {
            case NORMAL: {
                break;
            }
            case UNIQUE: {
                builder.append(" unique");
                break;
            }
            case FULLTEXT: {
                builder.append(" fulltext");
            }
        }
        builder.append(" index " + this.quickDAOConfig.database.escape(indexField.indexName) + " on " + this.quickDAOConfig.database.escape(indexField.tableName) + "(");
        for (String column : indexField.columns) {
            builder.append(this.quickDAOConfig.database.escape(column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        if (null != indexField.using && !indexField.using.isEmpty()) {
            builder.append(" using " + indexField.using);
        }
        if (null != indexField.comment && !indexField.comment.isEmpty()) {
            builder.append(" " + this.quickDAOConfig.database.comment(indexField.comment));
        }
        this.connectionExecutor.executeUpdate("\u6dfb\u52a0\u7d22\u5f15", builder.toString());
    }

    @Override
    public void dropIndex(String tableName, String indexName) throws SQLException {
        String dropIndexSQL = "drop index " + this.quickDAOConfig.database.escape(indexName);
        this.connectionExecutor.executeUpdate("\u5220\u9664\u7d22\u5f15", dropIndexSQL);
    }

    @Override
    public void createForeignKey(Property property) throws SQLException {
        if (!this.quickDAOConfig.openForeignKey) {
            return;
        }
        String operation = property.foreignKey.foreignKeyOption().getOperation();
        String reference = this.quickDAOConfig.database.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.database.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation;
        String foreignKeyName = "FK_" + property.entity.tableName + "_" + property.foreignKey.field() + "_" + this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName + "_" + property.name;
        if (this.hasConstraintExists(property.entity.tableName, foreignKeyName)) {
            return;
        }
        String foreignKeySQL = "alter table " + this.quickDAOConfig.database.escape(property.entity.tableName) + " add constraint " + this.quickDAOConfig.database.escape(foreignKeyName) + " foreign key(" + this.quickDAOConfig.database.escape(property.column) + ") references " + reference;
        this.connectionExecutor.executeUpdate("\u751f\u6210\u5916\u952e\u7ea6\u675f", foreignKeySQL);
    }

    @Override
    public void automaticCreateTableAndColumn() throws SQLException {
        Collection<Entity> entityList = this.quickDAOConfig.entityMap.values();
        ArrayList<Entity> newEntityList = new ArrayList<Entity>();
        HashMap<Entity, Entity> updateEntityMap = new HashMap<Entity, Entity>();
        for (Entity entity : entityList) {
            Entity dbEntity = this.quickDAOConfig.dbEntityList.stream().filter(entity1 -> entity1.tableName.equalsIgnoreCase(entity.tableName)).findFirst().orElse(null);
            if (null == dbEntity) {
                newEntityList.add(entity);
                continue;
            }
            updateEntityMap.put(entity, dbEntity);
        }
        if (this.quickDAOConfig.autoCreateTable) {
            for (Entity entity : newEntityList) {
                this.createTable(entity);
            }
        }
        if (this.quickDAOConfig.autoCreateProperty) {
            for (Map.Entry entry : updateEntityMap.entrySet()) {
                List<Property> propertyList = ((Entity)entry.getKey()).properties;
                for (Property property : propertyList) {
                    if (((Entity)entry.getValue()).properties.stream().noneMatch(property1 -> property1.column.equals(property.column))) {
                        this.createProperty(property);
                    }
                    if (null == property.foreignKey) continue;
                    this.createForeignKey(property);
                }
                List<IndexField> indexFieldList = ((Entity)entry.getKey()).indexFieldList;
                for (IndexField indexField : indexFieldList) {
                    if (!((Entity)entry.getValue()).indexFieldList.stream().noneMatch(indexField1 -> indexField1.indexName.equalsIgnoreCase(indexField.indexName))) continue;
                    this.createIndex(indexField);
                }
            }
        }
        if (null == this.quickDAOConfig.visualTableList || this.quickDAOConfig.visualTableList.isEmpty()) {
            this.quickDAOConfig.visualTableList = this.getVirtualEntity();
        }
    }

    @Override
    public void refreshDbEntityList() throws SQLException {
        this.getDatabaseName();
        List<Entity> dbEntityList = this.getDatabaseEntity();
        for (Entity dbEntity : dbEntityList) {
            dbEntity.escapeTableName = this.quickDAOConfig.database.escape(dbEntity.tableName);
            dbEntity.clazz = JSONObject.class;
            for (Property property : dbEntity.properties) {
                Class type;
                if (null != this.quickDAOConfig.columnTypeMapping && null != (type = this.quickDAOConfig.columnTypeMapping.columnMappingType(property))) {
                    property.className = type.getName();
                }
                property.entity = dbEntity;
            }
        }
        this.quickDAOConfig.dbEntityList = dbEntityList;
    }

    @Override
    public abstract Map<String, String> getTypeFieldMapping();

    protected List<Entity> getVirtualEntity() {
        return new ArrayList<Entity>();
    }

    protected abstract String getAutoIncrementSQL(Property var1);

    protected abstract void getIndex(List<Entity> var1) throws SQLException;

    protected abstract void getEntityPropertyList(List<Entity> var1) throws SQLException;

    protected abstract List<Entity> getEntityList() throws SQLException;
}

