/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.ddl;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.builder.ddl.MySQLDDLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class H2DDLBuilder
extends MySQLDDLBuilder {
    public H2DDLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public void getDatabaseName() throws SQLException {
        this.quickDAOConfig.databaseName = "PUBLIC";
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        String hasTableExistsSQL = "select table_name from information_schema.tables where table_name = '" + entity.tableName.toUpperCase() + "'";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728", hasTableExistsSQL);
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public boolean hasIndexExists(String tableName, String indexName) throws SQLException {
        String hasIndexExistsSQL = "select count(1) from information_schema.indexes where index_name = '" + indexName.toUpperCase() + "'";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728", hasIndexExistsSQL);
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        HashMap<String, String> fieldTypeMapping = new HashMap<String, String>();
        fieldTypeMapping.put("byte", "TINYINT");
        fieldTypeMapping.put("java.lang.Byte", "TINYINT");
        fieldTypeMapping.put("[B", "BINARY");
        fieldTypeMapping.put("boolean", "BOOLEAN");
        fieldTypeMapping.put("java.lang.Boolean", "BOOLEAN");
        fieldTypeMapping.put("char", "CHAR");
        fieldTypeMapping.put("java.lang.Character", "CHARACTER");
        fieldTypeMapping.put("short", "SMALLINT");
        fieldTypeMapping.put("java.lang.Short", "SMALLINT");
        fieldTypeMapping.put("int", "INT");
        fieldTypeMapping.put("java.lang.Integer", "INTEGER");
        fieldTypeMapping.put("float", "REAL");
        fieldTypeMapping.put("java.lang.Float", "REAL");
        fieldTypeMapping.put("long", "BIGINT");
        fieldTypeMapping.put("java.lang.Long", "BIGINT");
        fieldTypeMapping.put("double", "DOUBLE");
        fieldTypeMapping.put("java.lang.Double", "DOUBLE");
        fieldTypeMapping.put("java.lang.String", "VARCHAR(255)");
        fieldTypeMapping.put("java.util.Date", "DATETIME");
        fieldTypeMapping.put("java.sql.Date", "DATE");
        fieldTypeMapping.put("java.sql.Time", "TIME");
        fieldTypeMapping.put("java.sql.Timestamp", "TIMESTAMP");
        fieldTypeMapping.put("java.time.LocalDate", "DATE");
        fieldTypeMapping.put("java.time.LocalDateTime", "DATETIME");
        fieldTypeMapping.put("java.sql.Array", "ARRAY");
        fieldTypeMapping.put("java.math.BigDecimal", "DECIMAL");
        fieldTypeMapping.put("java.sql.Blob", "BLOB");
        fieldTypeMapping.put("java.sql.Clob", "CLOB");
        fieldTypeMapping.put("java.sql.NClob", "NCLOB");
        fieldTypeMapping.put("java.sql.Ref", "");
        fieldTypeMapping.put("java.net.URL", "");
        fieldTypeMapping.put("java.sql.RowId", "");
        fieldTypeMapping.put("java.sql.SQLXML", "");
        fieldTypeMapping.put("java.io.InputStream", "LONGTEXT");
        fieldTypeMapping.put("java.io.Reader", "LONGTEXT");
        return fieldTypeMapping;
    }

    @Override
    protected void getIndex(List<Entity> entityList) throws SQLException {
        String getIndexSQL = "select table_name, sql from information_schema.indexes";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f", getIndexSQL);
        block0: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                String sql = resultSet.getString("sql");
                String[] tokens = sql.split("\"");
                IndexField indexField = new IndexField();
                indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
                indexField.indexName = tokens[3];
                indexField.tableName = tokens[7];
                for (int i = 9; i < tokens.length - 1; ++i) {
                    indexField.columns.add(tokens[i]);
                }
                entity.indexFieldList.add(indexField);
                continue block0;
            }
        }
        resultSet.close();
    }

    @Override
    protected void getEntityPropertyList(List<Entity> entityList) throws SQLException {
        String getEntityPropertyListSQL = "select table_name, column_name, type_name, character_maximum_length, is_nullable, column_default from information_schema.`columns` where table_schema = '" + this.quickDAOConfig.databaseName + "'";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f", getEntityPropertyListSQL);
        block0: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                Property property = new Property();
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("type_name");
                if (property.columnType.contains(" ")) {
                    property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                }
                if (null != resultSet.getString("character_maximum_length")) {
                    property.columnType = property.columnType + "(" + resultSet.getString("character_maximum_length") + ")";
                }
                property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                if (null != resultSet.getString("column_default")) {
                    property.defaultValue = resultSet.getString("column_default");
                }
                entity.properties.add(property);
                continue block0;
            }
        }
        resultSet.close();
    }

    @Override
    protected List<Entity> getEntityList() throws SQLException {
        String getEntityListSQL = "show tables;";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5217\u8868", getEntityListSQL);
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (resultSet.next()) {
            Entity entity = new Entity();
            entity.tableName = resultSet.getString(1);
            entityList.add(entity);
        }
        resultSet.close();
        return entityList;
    }
}

