/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostgreDDLBuilder
extends AbstractDDLBuilder {
    public PostgreDDLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return this.quickDAOConfig.database.escape(property.column) + " SERIAL UNIQUE PRIMARY KEY";
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        String hasTableExistsSQL = "select tablename from pg_tables where schemaname='public' and tablename = '" + entity.tableName + "';";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728", hasTableExistsSQL);
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void createTable(Entity entity) throws SQLException {
        if (this.quickDAOConfig.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            String openForeignKeyCheck = "PRAGMA foreign_keys = ON;";
            this.connectionExecutor.executeUpdate("\u5f00\u542f\u5916\u952e\u7ea6\u675f", openForeignKeyCheck);
        }
        StringBuilder builder = new StringBuilder("create table " + entity.escapeTableName + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                builder.append(this.getAutoIncrementSQL(property));
            } else {
                builder.append(this.quickDAOConfig.database.escape(property.column) + " " + property.columnType);
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    builder.append(" default " + property.defaultValue);
                }
                if (property.notNull) {
                    builder.append(" not null");
                }
                if (null != property.comment) {
                    builder.append(" " + this.quickDAOConfig.database.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    builder.append(" check " + property.escapeCheck);
                }
            }
            builder.append(",");
        }
        if (this.quickDAOConfig.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                builder.append("foreign key(" + this.quickDAOConfig.database.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                builder.append(this.quickDAOConfig.database.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.database.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                builder.append(",");
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        if (null != entity.comment) {
            builder.append(" " + this.quickDAOConfig.database.comment(entity.comment));
        }
        this.connectionExecutor.executeUpdate("\u751f\u6210\u65b0\u8868", builder.toString());
        for (IndexField indexField : entity.indexFieldList) {
            this.createIndex(indexField);
        }
        if (null != entity.comment) {
            String entityCommentSQL = "comment on table \"" + entity.tableName + "\" is '" + entity.comment + "'";
            this.connectionExecutor.executeUpdate("\u521b\u5efa\u8868\u6ce8\u91ca", entityCommentSQL);
        }
        for (Property property : entity.properties) {
            if (property.comment == null) continue;
            String columnCommentSQL = "comment on column \"" + entity.tableName + "\".\"" + property.column + "\" is '" + property.comment + "'";
            this.connectionExecutor.executeUpdate("\u521b\u5efa\u8868\u5b57\u6bb5\u6ce8\u91ca", columnCommentSQL);
        }
    }

    @Override
    public boolean hasIndexExists(String tableName, String indexName) throws SQLException {
        String hasIndexExistsSQL = "select count(1) from pg_indexes where tablename = '" + tableName + "' and indexname = '" + indexName + "'";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728", hasIndexExistsSQL);
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void createIndex(IndexField indexField) throws SQLException {
        if (indexField.columns.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("create");
        switch (indexField.indexType) {
            case NORMAL: {
                break;
            }
            case UNIQUE: {
                builder.append(" unique");
                break;
            }
            case FULLTEXT: {
                builder.append(" fulltext");
            }
        }
        builder.append(" index " + this.quickDAOConfig.database.escape(indexField.indexName) + " on " + this.quickDAOConfig.database.escape(indexField.tableName));
        if (null != indexField.using && !indexField.using.isEmpty()) {
            builder.append(" using " + indexField.using);
        }
        builder.append("(");
        for (String column : indexField.columns) {
            builder.append(this.quickDAOConfig.database.escape(column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        if (null != indexField.comment && !indexField.comment.isEmpty()) {
            builder.append(" " + this.quickDAOConfig.database.comment(indexField.comment));
        }
        this.connectionExecutor.executeUpdate("\u6dfb\u52a0\u7d22\u5f15", builder.toString());
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) throws SQLException {
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        HashMap<String, String> fieldTypeMapping = new HashMap<String, String>();
        fieldTypeMapping.put("byte", "BOOLEAN");
        fieldTypeMapping.put("java.lang.Byte", "BOOLEAN");
        fieldTypeMapping.put("[B", "BIT");
        fieldTypeMapping.put("boolean", "BOOLEAN");
        fieldTypeMapping.put("java.lang.Boolean", "BOOLEAN");
        fieldTypeMapping.put("char", "CHAR");
        fieldTypeMapping.put("java.lang.Character", "CHARACTER");
        fieldTypeMapping.put("short", "SMALLINT");
        fieldTypeMapping.put("java.lang.Short", "SMALLINT");
        fieldTypeMapping.put("int", "INT");
        fieldTypeMapping.put("java.lang.Integer", "INTEGER");
        fieldTypeMapping.put("float", "FLOAT4");
        fieldTypeMapping.put("java.lang.Float", "FLOAT4");
        fieldTypeMapping.put("long", "BIGINT");
        fieldTypeMapping.put("java.lang.Long", "BIGINT");
        fieldTypeMapping.put("double", "FLOAT8");
        fieldTypeMapping.put("java.lang.Double", "FLOAT8");
        fieldTypeMapping.put("java.lang.String", "VARCHAR(255)");
        fieldTypeMapping.put("java.util.Date", "TIMESTAMP");
        fieldTypeMapping.put("java.sql.Date", "DATE");
        fieldTypeMapping.put("java.sql.Time", "TIME");
        fieldTypeMapping.put("java.sql.Timestamp", "TIMESTAMP");
        fieldTypeMapping.put("java.time.LocalDate", "DATE");
        fieldTypeMapping.put("java.time.LocalDateTime", "TIMESTAMP");
        fieldTypeMapping.put("java.sql.Array", "");
        fieldTypeMapping.put("java.math.BigDecimal", "DECIMAL");
        fieldTypeMapping.put("java.sql.Blob", "TEXT");
        fieldTypeMapping.put("java.sql.Clob", "TEXT");
        fieldTypeMapping.put("java.sql.NClob", "TEXT");
        fieldTypeMapping.put("java.sql.Ref", "");
        fieldTypeMapping.put("java.net.URL", "");
        fieldTypeMapping.put("java.sql.RowId", "");
        fieldTypeMapping.put("java.sql.SQLXML", "");
        fieldTypeMapping.put("java.io.InputStream", "TEXT");
        fieldTypeMapping.put("java.io.Reader", "TEXT");
        return fieldTypeMapping;
    }

    @Override
    protected void getIndex(List<Entity> entityList) throws SQLException {
        String getIndexSQL = "select tablename,indexname,indexdef from pg_indexes";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f", getIndexSQL);
        block0: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("tablename"))) continue;
                IndexField indexField = new IndexField();
                indexField.tableName = resultSet.getString("tablename");
                indexField.indexName = resultSet.getString("indexname");
                String def = resultSet.getString("indexdef");
                indexField.indexType = def.contains("UNIQUE INDEX") ? IndexType.UNIQUE : IndexType.NORMAL;
                indexField.using = def.substring(def.indexOf("USING") + "USING".length(), def.indexOf("(")).replace("\"", "");
                String[] columns = def.substring(def.indexOf("(") + 1, def.indexOf(")")).split(",");
                for (int i = 0; i < columns.length; ++i) {
                    indexField.columns.add(columns[i]);
                }
                entity.indexFieldList.add(indexField);
                continue block0;
            }
        }
        resultSet.close();
    }

    @Override
    protected void getEntityPropertyList(List<Entity> entityList) throws SQLException {
        String getEntityPropertyListSQL = "select pg_class.relname as table_name, attname as column_name, attnum as oridinal_position, attnotnull as notnull, format_type(atttypid,atttypmod) as type, col_description(attrelid, attnum) as comment from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f", getEntityPropertyListSQL);
        block0: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                Property property = new Property();
                property.column = resultSet.getString("column_name");
                property.columnType = resultSet.getString("type");
                property.notNull = "t".equals(resultSet.getString("notnull"));
                property.comment = resultSet.getString("comment");
                property.position = resultSet.getInt("oridinal_position");
                entity.properties.add(property);
                continue block0;
            }
        }
        resultSet.close();
        String getEntityPropertyTypeListSQL = "select table_name, ordinal_position,column_name,column_default,is_nullable,udt_name,character_maximum_length,column_default from information_schema.columns";
        resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f", getEntityPropertyTypeListSQL);
        block2: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("table_name"))) continue;
                for (Property property : entity.properties) {
                    if (!property.column.equalsIgnoreCase(resultSet.getString("column_name"))) continue;
                    property.columnType = resultSet.getString("udt_name");
                    if (null != resultSet.getObject("character_maximum_length")) {
                        property.columnType = property.columnType + "(" + resultSet.getInt("character_maximum_length") + ")";
                    }
                    if (null == resultSet.getString("column_default")) continue block2;
                    property.defaultValue = resultSet.getString("column_default");
                    continue block2;
                }
                continue block2;
            }
        }
        resultSet.close();
        String getPrimaryKeySQL = "select relname, conkey from pg_constraint join pg_class on pg_class.oid = pg_constraint.conrelid where contype = 'p'";
        resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u4e3b\u952e\u7ea6\u675f", getPrimaryKeySQL);
        block5: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("relname"))) continue;
                String conkey = resultSet.getString("conkey");
                for (Property property : entity.properties) {
                    if (!conkey.contains(property.position + "")) continue;
                    property.id = true;
                    property.strategy = IdStrategy.AutoIncrement;
                }
                continue block5;
            }
        }
        resultSet.close();
    }

    @Override
    protected List<Entity> getEntityList() throws SQLException {
        String getEntityListSQL = "select relname as name,cast(obj_description(relfilenode,'pg_class') as varchar) as comment from pg_class c where  relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5217\u8868", getEntityListSQL);
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (resultSet.next()) {
            Entity entity = new Entity();
            entity.tableName = resultSet.getString("name");
            entity.comment = resultSet.getString("comment");
            entityList.add(entity);
        }
        resultSet.close();
        return entityList;
    }
}

