/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.ddl;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLiteDDLBuilder
extends AbstractDDLBuilder {
    public SQLiteDDLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public boolean hasTableExists(Entity entity) throws SQLException {
        String hasTableExistsSQL = "select name from sqlite_master where type='table' and name = '" + entity.tableName + "';";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u5224\u65ad\u8868\u662f\u5426\u5b58\u5728", hasTableExistsSQL);
        boolean result = false;
        if (resultSet.next()) {
            result = true;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void createTable(Entity entity) throws SQLException {
        if (this.quickDAOConfig.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            String openForeignKeyCheck = "PRAGMA foreign_keys = ON;";
            this.connectionExecutor.executeUpdate("\u5f00\u542f\u5916\u952e\u7ea6\u675f", openForeignKeyCheck);
        }
        StringBuilder builder = new StringBuilder("create table " + entity.escapeTableName + "(");
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) {
                builder.append(this.getAutoIncrementSQL(property));
            } else {
                builder.append(this.quickDAOConfig.database.escape(property.column) + " " + property.columnType);
                if (property.notNull) {
                    builder.append(" not null");
                }
                if (null != property.defaultValue && !property.defaultValue.isEmpty()) {
                    builder.append(" default " + property.defaultValue);
                }
                if (null != property.comment) {
                    builder.append(" " + this.quickDAOConfig.database.comment(property.comment));
                }
                if (null != property.escapeCheck && !property.escapeCheck.isEmpty()) {
                    builder.append(" check " + property.escapeCheck);
                }
            }
            builder.append(",");
        }
        if (this.quickDAOConfig.openForeignKey && null != entity.foreignKeyProperties && entity.foreignKeyProperties.size() > 0) {
            for (Property property : entity.foreignKeyProperties) {
                builder.append("foreign key(" + this.quickDAOConfig.database.escape(property.column) + ") references ");
                String operation = property.foreignKey.foreignKeyOption().getOperation();
                builder.append(this.quickDAOConfig.database.escape(this.quickDAOConfig.getEntityByClassName((String)property.foreignKey.table().getName()).tableName) + "(" + this.quickDAOConfig.database.escape(property.foreignKey.field()) + ") ON DELETE " + operation + " ON UPDATE " + operation);
                builder.append(",");
            }
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        if (null != entity.comment) {
            builder.append(" " + this.quickDAOConfig.database.comment(entity.comment));
        }
        this.connectionExecutor.executeUpdate("\u751f\u6210\u65b0\u8868", builder.toString());
        for (IndexField indexField : entity.indexFieldList) {
            this.createIndex(indexField);
        }
    }

    @Override
    protected String getAutoIncrementSQL(Property property) {
        return property.column + " " + property.columnType + " primary key autoincrement";
    }

    @Override
    public void dropColumn(Property property) throws SQLException {
        throw new UnsupportedOperationException("SQLite\u4e0d\u652f\u6301\u5220\u9664\u5217");
    }

    @Override
    public boolean hasIndexExists(String tableName, String indexName) throws SQLException {
        String hasIndexExistsSQL = "select count(1) from sqlite_master where type = 'index' and name = '" + indexName + "'";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u67e5\u770b\u7d22\u5f15\u662f\u5426\u5b58\u5728", hasIndexExistsSQL);
        boolean result = false;
        if (resultSet.next()) {
            result = resultSet.getInt(1) > 0;
        }
        resultSet.close();
        return result;
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) throws SQLException {
        String foreignConstraintCheckSQL = "PRAGMA foreign_keys = " + enable;
        this.connectionExecutor.executeUpdate(enable ? "\u542f\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5" : "\u7981\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5", foreignConstraintCheckSQL);
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        HashMap<String, String> fieldTypeMapping = new HashMap<String, String>();
        fieldTypeMapping.put("byte", "TINYINT");
        fieldTypeMapping.put("java.lang.Byte", "TINYINT");
        fieldTypeMapping.put("[B", "BLOB");
        fieldTypeMapping.put("boolean", "BOOLEAN");
        fieldTypeMapping.put("java.lang.Boolean", "BOOLEAN");
        fieldTypeMapping.put("char", "TINYINT");
        fieldTypeMapping.put("java.lang.Character", "TINYINT");
        fieldTypeMapping.put("short", "SMALLINT");
        fieldTypeMapping.put("java.lang.Short", "SMALLINT");
        fieldTypeMapping.put("int", "INT");
        fieldTypeMapping.put("java.lang.Integer", "INTEGER");
        fieldTypeMapping.put("float", "FLOAT");
        fieldTypeMapping.put("java.lang.Float", "FLOAT");
        fieldTypeMapping.put("long", "INTEGER");
        fieldTypeMapping.put("java.lang.Long", "INTEGER");
        fieldTypeMapping.put("double", "DOUBLE");
        fieldTypeMapping.put("java.lang.Double", "DOUBLE");
        fieldTypeMapping.put("java.lang.String", "VARCHAR(255)");
        fieldTypeMapping.put("java.util.Date", "DATETIME");
        fieldTypeMapping.put("java.sql.Date", "DATE");
        fieldTypeMapping.put("java.sql.Time", "");
        fieldTypeMapping.put("java.sql.Timestamp", "DATETIME");
        fieldTypeMapping.put("java.time.LocalDate", "DATE");
        fieldTypeMapping.put("java.time.LocalDateTime", "DATETIME");
        fieldTypeMapping.put("java.sql.Array", "");
        fieldTypeMapping.put("java.math.BigDecimal", "DECIMAL");
        fieldTypeMapping.put("java.sql.Blob", "BLOB");
        fieldTypeMapping.put("java.sql.Clob", "TEXT");
        fieldTypeMapping.put("java.sql.NClob", "TEXT");
        fieldTypeMapping.put("java.sql.Ref", "");
        fieldTypeMapping.put("java.net.URL", "");
        fieldTypeMapping.put("java.sql.RowId", "");
        fieldTypeMapping.put("java.sql.SQLXML", "");
        fieldTypeMapping.put("java.io.InputStream", "TEXT");
        fieldTypeMapping.put("java.io.Reader", "TEXT");
        return fieldTypeMapping;
    }

    @Override
    protected void getIndex(List<Entity> entityList) throws SQLException {
        String getIndexSQL = "select tbl_name, sql from sqlite_master where type='index' and sql is not null";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u7d22\u5f15\u4fe1\u606f", getIndexSQL);
        block0: while (resultSet.next()) {
            for (Entity entity : entityList) {
                if (!entity.tableName.equalsIgnoreCase(resultSet.getString("tbl_name"))) continue;
                String sql = resultSet.getString("sql");
                String[] tokens = sql.split("`");
                IndexField indexField = new IndexField();
                indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
                indexField.indexName = tokens[1];
                indexField.tableName = tokens[3];
                for (int i = 5; i < tokens.length - 1; ++i) {
                    indexField.columns.add(tokens[i]);
                }
                entity.indexFieldList.add(indexField);
                continue block0;
            }
        }
        resultSet.close();
    }

    @Override
    protected void getEntityPropertyList(List<Entity> entityList) throws SQLException {
        for (Entity entity : entityList) {
            String getEntityPropertyListSQL = "PRAGMA table_info(`" + entity.tableName + "`)";
            ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f", getEntityPropertyListSQL);
            while (resultSet.next()) {
                Property property = new Property();
                property.column = resultSet.getString("name");
                property.columnType = resultSet.getString("type");
                property.notNull = "1".equals(resultSet.getString("notnull"));
                if (null != resultSet.getString("dflt_value")) {
                    property.defaultValue = resultSet.getString("dflt_value");
                }
                if (1 == resultSet.getInt("pk")) {
                    property.id = true;
                    property.strategy = IdStrategy.AutoIncrement;
                }
                entity.properties.add(property);
            }
            resultSet.close();
        }
    }

    @Override
    protected List<Entity> getEntityList() throws SQLException {
        String getEntityListSQL = "select name from sqlite_master where type='table' and name != 'sqlite_sequence';";
        ResultSet resultSet = this.connectionExecutor.executeQuery("\u83b7\u53d6\u8868\u5217\u8868", getEntityListSQL);
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        while (resultSet.next()) {
            Entity entity = new Entity();
            entity.tableName = resultSet.getString("name");
            entityList.add(entity);
        }
        resultSet.close();
        return entityList;
    }
}

