/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.dml;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.AbstractSQLBuilder;
import cn.schoolwow.quickdao.builder.dml.DMLBuilder;
import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;

public class AbstractDMLBuilder
extends AbstractSQLBuilder
implements DMLBuilder {
    public AbstractDMLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public ConnectionExecutorItem insert(Object instance) throws Exception {
        String sql = this.insert(instance.getClass());
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u63d2\u5165\u5bf9\u8c61", sql);
        StringBuilder builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        this.insert(connectionExecutorItem.preparedStatement, instance, builder);
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem[] insert(Object[] instances) throws Exception {
        String sql = this.insert(instances[0].getClass());
        ConnectionExecutorItem[] connectionExecutorItems = new ConnectionExecutorItem[instances.length];
        this.connectionExecutor.connection.setAutoCommit(false);
        for (int i = 0; i < instances.length; ++i) {
            ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6279\u91cf\u63d2\u5165\u5bf9\u8c61", sql);
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.insert(connectionExecutorItem.preparedStatement, instances[i], sqlBuilder);
            connectionExecutorItem.sql = sqlBuilder.toString();
            connectionExecutorItems[i] = connectionExecutorItem;
        }
        return connectionExecutorItems;
    }

    @Override
    public int insertBatch(Object[] instances) throws Exception {
        String sql = this.insert(instances[0].getClass());
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6279\u91cf\u63d2\u5165\u5bf9\u8c61", sql);
        this.connectionExecutor.connection.setAutoCommit(false);
        int effect = 0;
        for (int i = 0; i < instances.length; ++i) {
            int[] batches;
            Object instance = instances[i];
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.insert(connectionExecutorItem.preparedStatement, instance, sqlBuilder);
            connectionExecutorItem.preparedStatement.addBatch();
            if ((i == 0 || i % this.quickDAOConfig.perBatchCommit != 0) && i != instances.length - 1) continue;
            block5: for (int batch : batches = connectionExecutorItem.preparedStatement.executeBatch()) {
                switch (batch) {
                    case -2: {
                        ++effect;
                        continue block5;
                    }
                    case -3: {
                        continue block5;
                    }
                    default: {
                        effect += batch;
                    }
                }
            }
            this.connectionExecutor.connection.commit();
            connectionExecutorItem.preparedStatement.clearBatch();
        }
        connectionExecutorItem.preparedStatement.close();
        return effect;
    }

    @Override
    public ConnectionExecutorItem updateByUniqueKey(Object instance) throws Exception {
        String sql = this.updateByUniqueKey(instance.getClass());
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u66f4\u65b0\u5bf9\u8c61", sql);
        StringBuilder builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        this.updateByUniqueKey(connectionExecutorItem.preparedStatement, instance, builder);
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem updateByUniqueKey(Object[] instances) throws Exception {
        String sql = this.updateByUniqueKey(instances[0].getClass());
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636e\u552f\u4e00\u6027\u7ea6\u675f\u6279\u91cf\u66f4\u65b0\u5bf9\u8c61", sql);
        this.connectionExecutor.connection.setAutoCommit(false);
        StringBuilder builder = new StringBuilder();
        for (Object instance : instances) {
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.updateByUniqueKey(connectionExecutorItem.preparedStatement, instance, sqlBuilder);
            builder.append(sqlBuilder.toString() + ";");
            connectionExecutorItem.preparedStatement.addBatch();
        }
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem updateById(Object instance) throws Exception {
        String sql = this.updateById(instance.getClass());
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636eID\u66f4\u65b0\u5bf9\u8c61", sql);
        StringBuilder builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        this.updateById(connectionExecutorItem.preparedStatement, instance, builder);
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem updateById(Object[] instances) throws Exception {
        String sql = this.updateById(instances[0].getClass());
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636eID\u6279\u91cf\u66f4\u65b0\u5bf9\u8c61", sql);
        this.connectionExecutor.connection.setAutoCommit(false);
        StringBuilder builder = new StringBuilder();
        for (Object instance : instances) {
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            this.updateById(connectionExecutorItem.preparedStatement, instance, sqlBuilder);
            builder.append(sqlBuilder.toString() + ";");
            connectionExecutorItem.preparedStatement.addBatch();
        }
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem deleteByProperty(Class clazz, String property, Object value) throws SQLException {
        String key = "deleteByProperty_" + clazz.getName() + "_" + property + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            StringBuilder builder = new StringBuilder();
            builder.append("delete from " + entity.escapeTableName + " where " + this.quickDAOConfig.database.escape(entity.getColumnNameByFieldName(property)) + " = ?");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.sqlCache.get(key);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u5220\u9664", sql);
        connectionExecutorItem.preparedStatement.setObject(1, value);
        connectionExecutorItem.sql = sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString());
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem deleteByProperty(String tableName, String property, Object value) throws SQLException {
        String sql = "delete from " + this.quickDAOConfig.database.escape(tableName) + " where " + this.quickDAOConfig.database.escape(property) + " = ?";
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u5220\u9664", sql);
        connectionExecutorItem.preparedStatement.setObject(1, value);
        connectionExecutorItem.sql = sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString());
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem clear(Class clazz) throws SQLException {
        String key = "clear_" + clazz.getName() + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            this.quickDAOConfig.sqlCache.put(key, "delete from " + entity.escapeTableName);
        }
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6e05\u7a7a\u8868", this.quickDAOConfig.sqlCache.get(key));
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem clear(String tableName) throws SQLException {
        String key = "clear_" + tableName + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            this.quickDAOConfig.sqlCache.put(key, "delete from " + tableName);
        }
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6e05\u7a7a\u8868", this.quickDAOConfig.sqlCache.get(key));
        return connectionExecutorItem;
    }

    private String insert(Class clazz) {
        String key = "insert_" + clazz.getName() + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            builder.append("insert into " + entity.escapeTableName + "(");
            for (Property property : entity.properties) {
                if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(") values(");
            for (Property property : entity.properties) {
                if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
                builder.append((null == property.function ? "?" : property.function) + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(")");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        return this.quickDAOConfig.sqlCache.get(key);
    }

    private void insert(PreparedStatement preparedStatement, Object instance, StringBuilder sqlBuilder) throws Exception {
        int parameterIndex = 1;
        Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        for (Property property : entity.properties) {
            if (property.id && property.strategy == IdStrategy.AutoIncrement) continue;
            if (property.id && property.strategy == IdStrategy.IdGenerator) {
                Field idField = instance.getClass().getDeclaredField(property.name);
                idField.setAccessible(true);
                String value = this.quickDAOConfig.idGenerator.getNextId();
                switch (idField.getType().getName()) {
                    case "int": {
                        idField.setInt(instance, Integer.parseInt(value));
                        break;
                    }
                    case "java.lang.Integer": {
                        idField.set(instance, Integer.parseInt(value));
                        break;
                    }
                    case "long": {
                        idField.setLong(instance, Long.parseLong(value));
                        break;
                    }
                    case "java.lang.Long": {
                        idField.set(instance, Long.parseLong(value));
                        break;
                    }
                    case "java.lang.String": {
                        idField.set(instance, value);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u5f53\u524d\u4ec5\u652f\u6301int,long,String\u7c7b\u578b\u7684\u81ea\u589e\u4e3b\u952e!\u81ea\u589e\u5b57\u6bb5\u540d\u79f0:" + idField.getName() + ",\u7c7b\u578b:" + idField.getType().getName() + "!");
                    }
                }
            }
            if (property.createdAt || property.updateAt) {
                this.setCurrentDateTime(property, instance);
            }
            Object value = null;
            if (null != this.quickDAOConfig.insertColumnValueFunction) {
                value = this.quickDAOConfig.insertColumnValueFunction.apply(property);
            }
            if (null != value) {
                this.setParameter(value, preparedStatement, parameterIndex, sqlBuilder);
            } else {
                this.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            }
            ++parameterIndex;
        }
    }

    private String updateByUniqueKey(Class clazz) {
        String key = "updateByUniqueKey_" + clazz.getName() + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            builder.append("update " + entity.escapeTableName + " set ");
            for (Property property : entity.properties) {
                if (property.id || entity.uniqueProperties.contains(property) || property.createdAt) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + " = " + (null == property.function ? "?" : property.function) + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(" where ");
            for (Property property : entity.properties) {
                if (!entity.uniqueProperties.contains(property) || property.id) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + " = ? and ");
            }
            builder.delete(builder.length() - 5, builder.length());
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        return this.quickDAOConfig.sqlCache.get(key);
    }

    private void updateByUniqueKey(PreparedStatement preparedStatement, Object instance, StringBuilder sqlBuilder) throws Exception {
        int parameterIndex = 1;
        Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        for (Property property : entity.properties) {
            if (property.id || entity.uniqueProperties.contains(property) || property.createdAt) continue;
            if (property.updateAt) {
                this.setCurrentDateTime(property, instance);
            }
            Object value = null;
            if (null != this.quickDAOConfig.updateColumnValueFunction) {
                value = this.quickDAOConfig.updateColumnValueFunction.apply(property);
            }
            if (null != value) {
                this.setParameter(value, preparedStatement, parameterIndex, sqlBuilder);
            } else {
                this.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            }
            ++parameterIndex;
        }
        for (Property property : entity.properties) {
            if (!entity.uniqueProperties.contains(property) || property.id) continue;
            this.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            ++parameterIndex;
        }
    }

    private String updateById(Class clazz) {
        String key = "updateById_" + clazz.getName() + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            builder.append("update " + entity.escapeTableName + " set ");
            for (Property property : entity.properties) {
                if (property.id || property.createdAt) continue;
                builder.append(this.quickDAOConfig.database.escape(property.column) + " = ?,");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(" where " + this.quickDAOConfig.database.escape(entity.id.column) + " = ?");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        return this.quickDAOConfig.sqlCache.get(key);
    }

    private void updateById(PreparedStatement preparedStatement, Object instance, StringBuilder sqlBuilder) throws Exception {
        int parameterIndex = 1;
        Entity entity = this.quickDAOConfig.getEntityByClassName(instance.getClass().getName());
        for (Property property : entity.properties) {
            if (property.id || property.createdAt) continue;
            if (property.updateAt) {
                this.setCurrentDateTime(property, instance);
            }
            Object value = null;
            if (null != this.quickDAOConfig.updateColumnValueFunction) {
                value = this.quickDAOConfig.updateColumnValueFunction.apply(property);
            }
            if (null != value) {
                this.setParameter(value, preparedStatement, parameterIndex, sqlBuilder);
            } else {
                this.setParameter(instance, property, preparedStatement, parameterIndex, sqlBuilder);
            }
            ++parameterIndex;
        }
        this.setParameter(instance, entity.id, preparedStatement, parameterIndex, sqlBuilder);
    }

    private void setCurrentDateTime(Property property, Object instance) throws Exception {
        Field field = this.getFieldFromInstance(instance, property);
        switch (property.className) {
            case "java.util.Date": {
                field.set(instance, new java.util.Date(System.currentTimeMillis()));
                break;
            }
            case "java.sql.Date": {
                field.set(instance, new Date(System.currentTimeMillis()));
                break;
            }
            case "java.sql.Timestamp": {
                field.set(instance, new Timestamp(System.currentTimeMillis()));
                break;
            }
            case "java.util.Calendar": {
                field.set(instance, Calendar.getInstance());
                break;
            }
            case "java.time.LocalDate": {
                field.set(instance, LocalDate.now());
                break;
            }
            case "java.time.LocalDateTime": {
                field.set(instance, LocalDateTime.now());
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u8be5\u65e5\u671f\u7c7b\u578b,\u76ee\u524d\u652f\u6301\u7684\u7c7b\u578b\u4e3aDate,Calendar,LocalDate,LocalDateTime!\u5f53\u524d\u7c7b\u578b:" + property.className);
            }
        }
    }
}

