/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.builder.dql;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.builder.AbstractSQLBuilder;
import cn.schoolwow.quickdao.builder.dql.DQLBuilder;
import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.query.condition.AbstractCondition;
import com.alibaba.fastjson.JSONObject;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AbstractDQLBuilder
extends AbstractSQLBuilder
implements DQLBuilder {
    public AbstractDQLBuilder(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
    }

    @Override
    public ConnectionExecutorItem fetchNull(Class clazz, String field) throws SQLException {
        String key = "fetchNull_" + clazz.getName() + "_" + field + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(entity, "t"));
            builder.append(" from " + entity.escapeTableName + " as t where t." + this.quickDAOConfig.database.escape(entity.getColumnNameByFieldName(field)) + " is null");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.sqlCache.get(key);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("Null\u67e5\u8be2", sql);
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem fetch(Class clazz, long id) throws SQLException {
        Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
        return this.fetch(clazz, entity.id.column, (Object)(id + ""));
    }

    @Override
    public ConnectionExecutorItem fetch(Class clazz, String field, Object value) throws SQLException {
        String key = "fetch_" + clazz.getName() + "_" + field + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(entity, "t"));
            Property property = entity.getPropertyByFieldName(field);
            builder.append(" from " + entity.escapeTableName + " t where t." + this.quickDAOConfig.database.escape(entity.getColumnNameByFieldName(field)) + " = " + (null == property || null == property.function ? "?" : property.function) + "");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.sqlCache.get(key);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2", sql);
        connectionExecutorItem.preparedStatement.setObject(1, value);
        connectionExecutorItem.sql = sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString());
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem fetchNull(String tableName, String field) throws SQLException {
        String key = "fetchNull_" + tableName + "_" + field + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            Entity dbEntity = this.quickDAOConfig.getDbEntityByTableName(tableName);
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(dbEntity, "t"));
            builder.append(" from " + dbEntity.escapeTableName + " as t where t." + this.quickDAOConfig.database.escape(dbEntity.getColumnNameByFieldName(field)) + " is null");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.sqlCache.get(key);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("Null\u67e5\u8be2", sql);
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem fetch(String tableName, String field, Object value) throws SQLException {
        String key = "fetch_" + tableName + "_" + field + "_" + ((Object)((Object)this.quickDAOConfig.database)).getClass().getSimpleName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            Entity dbEntity = this.quickDAOConfig.getDbEntityByTableName(tableName);
            StringBuilder builder = new StringBuilder("select ");
            builder.append(this.columns(dbEntity, "t"));
            builder.append(" from " + dbEntity.escapeTableName + " t where t." + this.quickDAOConfig.database.escape(dbEntity.getColumnNameByFieldName(field)) + " = ?");
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        String sql = this.quickDAOConfig.sqlCache.get(key);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6839\u636e\u5355\u4e2a\u5b57\u6bb5\u67e5\u8be2", sql);
        connectionExecutorItem.preparedStatement.setObject(1, value);
        connectionExecutorItem.sql = sql.replace("?", value instanceof String ? "'" + value.toString() + "'" : value.toString());
        return connectionExecutorItem;
    }

    @Override
    public int getResultSetRowCount(Query query) throws SQLException {
        query.parameterIndex = 1;
        StringBuilder builder = new StringBuilder("select count(1) from ( select " + query.distinct + " ");
        if (query.column.length() > 0) {
            builder.append(query.column);
        } else {
            builder.append(this.columns(query.entity, query.tableAliasName));
        }
        builder.append(" from " + query.entity.escapeTableName);
        if (null != query.entity.clazz) {
            builder.append(" " + query.tableAliasName);
        }
        this.addJoinTableStatement(query, builder);
        builder.append(" " + query.where + " " + query.groupBy + " " + query.having + " ) foo");
        String sql = builder.toString();
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u83b7\u53d6\u884c\u6570", sql);
        builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        this.addArraySQLParameters(connectionExecutorItem.preparedStatement, query, query, builder);
        connectionExecutorItem.sql = builder.toString();
        ResultSet resultSet = this.connectionExecutor.executeQuery(connectionExecutorItem);
        int count = -1;
        if (resultSet.next()) {
            count = resultSet.getInt(1);
        }
        this.connectionExecutor.count = count;
        resultSet.close();
        query.parameterIndex = 1;
        return count;
    }

    @Override
    public ConnectionExecutorItem count(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("select count(1) from ( select " + query.distinct + " ");
        if (query.column.length() > 0) {
            builder.append(query.column);
        } else {
            builder.append(this.columns(query.entity, query.tableAliasName));
        }
        builder.append(" from " + query.entity.escapeTableName);
        if (null != query.entity.clazz) {
            builder.append(" " + query.tableAliasName);
        }
        this.addJoinTableStatement(query, builder);
        builder.append(" " + query.where + " " + query.groupBy + " " + query.having + " ) foo");
        String sql = builder.toString();
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u83b7\u53d6\u603b\u884c\u6570", sql);
        builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        this.addArraySQLParameters(connectionExecutorItem.preparedStatement, query, query, builder);
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem insert(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("insert into " + query.entity.escapeTableName + "(");
        builder.append(query.insertBuilder.toString() + ") values(");
        for (int i = 0; i < query.insertParameterList.size(); ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        String sql = builder.toString();
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u63d2\u5165\u8bb0\u5f55", sql);
        builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        for (Object parameter : query.insertParameterList) {
            this.setParameter(parameter, connectionExecutorItem.preparedStatement, query.parameterIndex++, builder);
        }
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem[] insertArray(Query query) throws SQLException {
        String sql = this.insertArraySQL(query);
        this.connectionExecutor.connection.setAutoCommit(false);
        ConnectionExecutorItem[] connectionExecutorItems = new ConnectionExecutorItem[query.insertArray.size()];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < connectionExecutorItems.length; ++i) {
            ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u63d2\u5165\u8bb0\u5f55", sql);
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            JSONObject o = query.insertArray.getJSONObject(i);
            int parameterIndex = 1;
            for (int j = 0; j < query.entity.properties.size(); ++j) {
                Property property = query.entity.properties.get(j);
                if (property.id && property.strategy.equals((Object)IdStrategy.AutoIncrement)) continue;
                Object value = null;
                if (null != this.quickDAOConfig.insertColumnValueFunction) {
                    value = this.quickDAOConfig.insertColumnValueFunction.apply(property);
                }
                this.setParameter(null != value ? value : o.get((Object)property.column), connectionExecutorItem.preparedStatement, parameterIndex++, sqlBuilder);
            }
            builder.append(sqlBuilder.toString() + ";");
            connectionExecutorItem.sql = sqlBuilder.toString();
            connectionExecutorItems[i] = connectionExecutorItem;
        }
        return connectionExecutorItems;
    }

    @Override
    public int insertArrayBatch(Query query) throws SQLException {
        String sql = this.insertArraySQL(query);
        this.connectionExecutor.connection.setAutoCommit(false);
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6279\u91cf\u63d2\u5165\u8bb0\u5f55", sql);
        int effect = 0;
        int perBatchCommit = Math.max(query.perBatchCommit, this.quickDAOConfig.perBatchCommit);
        int length = query.insertArray.size();
        for (int i = 0; i < length; ++i) {
            int[] batches;
            StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
            JSONObject o = query.insertArray.getJSONObject(i);
            int parameterIndex = 1;
            for (int j = 0; j < query.entity.properties.size(); ++j) {
                Property property = query.entity.properties.get(j);
                if (property.id && property.strategy.equals((Object)IdStrategy.AutoIncrement)) continue;
                Object value = null;
                if (null != this.quickDAOConfig.insertColumnValueFunction) {
                    value = this.quickDAOConfig.insertColumnValueFunction.apply(property);
                }
                this.setParameter(null != value ? value : o.get((Object)property.column), connectionExecutorItem.preparedStatement, parameterIndex++, sqlBuilder);
            }
            connectionExecutorItem.preparedStatement.addBatch();
            if ((i == 0 || i % perBatchCommit != 0) && i != length - 1) continue;
            block6: for (int batch : batches = connectionExecutorItem.preparedStatement.executeBatch()) {
                switch (batch) {
                    case -2: {
                        ++effect;
                        continue block6;
                    }
                    case -3: {
                        continue block6;
                    }
                    default: {
                        effect += batch;
                    }
                }
            }
            this.connectionExecutor.connection.commit();
            connectionExecutorItem.preparedStatement.clearBatch();
        }
        connectionExecutorItem.preparedStatement.close();
        return effect;
    }

    @Override
    public ConnectionExecutorItem update(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("update " + query.entity.escapeTableName + " ");
        builder.append(query.setBuilder.toString() + " " + query.where.replace(query.tableAliasName + ".", ""));
        String sql = builder.toString();
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6279\u91cf\u66f4\u65b0", sql);
        builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        for (Object parameter : query.updateParameterList) {
            this.setParameter(parameter, connectionExecutorItem.preparedStatement, query.parameterIndex++, builder);
        }
        this.addMainTableParameters(connectionExecutorItem.preparedStatement, query, query, builder);
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem delete(Query query) throws SQLException {
        StringBuilder builder = new StringBuilder("delete from " + query.quickDAOConfig.database.escape(query.entity.tableName));
        builder.append(" " + query.where.replace(query.tableAliasName + ".", ""));
        String sql = builder.toString();
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u6279\u91cf\u5220\u9664", sql);
        builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        this.addMainTableParameters(connectionExecutorItem.preparedStatement, query, query, builder);
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public ConnectionExecutorItem getArray(Query query) throws SQLException {
        StringBuilder builder = null;
        if (query.unionList.isEmpty()) {
            builder = this.getArraySQL(query);
        } else {
            builder = this.getUnionArraySQL(query);
            for (AbstractCondition abstractCondition : query.unionList) {
                switch (abstractCondition.query.unionType) {
                    case Union: {
                        builder.append(" union ");
                        break;
                    }
                    case UnionAll: {
                        builder.append(" union all ");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684Union\u7c7b\u578b!\u5f53\u524d\u7c7b\u578b:" + (Object)((Object)abstractCondition.query.unionType));
                    }
                }
                builder.append((CharSequence)this.getUnionArraySQL(abstractCondition.query));
            }
            builder.append(" " + query.orderBy + " " + query.limit);
        }
        String sql = builder.toString();
        ConnectionExecutorItem connectionExecutorItem = this.connectionExecutor.newConnectionExecutorItem("\u83b7\u53d6\u5217\u8868", sql);
        builder = new StringBuilder(sql.replace("?", "** NOT SPECIFIED **"));
        this.addArraySQLParameters(connectionExecutorItem.preparedStatement, query, query, builder);
        for (AbstractCondition abstractCondition : query.unionList) {
            Query unionQuery = abstractCondition.query;
            for (SubQuery subQuery : unionQuery.subQueryList) {
                if (null == subQuery.subQuery) continue;
                this.addMainTableParameters(connectionExecutorItem.preparedStatement, subQuery.subQuery, query, builder);
            }
            this.addMainTableParameters(connectionExecutorItem.preparedStatement, unionQuery, query, builder);
            for (SubQuery parameter : unionQuery.havingParameterList) {
                this.setParameter(parameter, connectionExecutorItem.preparedStatement, query.parameterIndex++, builder);
            }
        }
        connectionExecutorItem.sql = builder.toString();
        return connectionExecutorItem;
    }

    @Override
    public StringBuilder getArraySQL(Query query) {
        StringBuilder builder = this.getUnionArraySQL(query);
        builder.append(" " + query.orderBy + " " + query.limit);
        return builder;
    }

    private StringBuilder getUnionArraySQL(Query query) {
        StringBuilder builder = new StringBuilder("select " + query.distinct + " ");
        if (query.column.length() > 0) {
            builder.append(query.column);
        } else {
            builder.append(this.columns(query.entity, query.tableAliasName));
        }
        if (query.compositField) {
            for (SubQuery subQuery : query.subQueryList) {
                builder.append("," + this.columns(subQuery.entity, subQuery.tableAliasName));
            }
        }
        builder.append(" from " + query.entity.escapeTableName);
        if (null != query.entity.clazz) {
            builder.append(" " + query.tableAliasName);
        }
        this.addJoinTableStatement(query, builder);
        builder.append(" " + query.where + " " + query.groupBy + " " + query.having);
        return builder;
    }

    private void addJoinTableStatement(Query query, StringBuilder sqlBuilder) {
        for (SubQuery subQuery : query.subQueryList) {
            sqlBuilder.append(" " + subQuery.join + " ");
            if (null == subQuery.subQuerySQLBuilder) {
                sqlBuilder.append(query.quickDAOConfig.database.escape(subQuery.entity.tableName));
            } else {
                sqlBuilder.append("(" + subQuery.subQuerySQLBuilder.toString() + ")");
            }
            sqlBuilder.append(" " + subQuery.tableAliasName);
            if (null == subQuery.primaryField || null == subQuery.joinTableField) continue;
            sqlBuilder.append(" on ");
            if (subQuery.parentSubQuery == null) {
                sqlBuilder.append(query.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.primaryField) + " = " + subQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.joinTableField) + " ");
            } else {
                sqlBuilder.append(subQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.joinTableField) + " = " + subQuery.parentSubQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(subQuery.primaryField) + " ");
            }
            if (subQuery.onConditionMap.isEmpty()) continue;
            Set<Map.Entry<String, String>> entrySet = subQuery.onConditionMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                sqlBuilder.append(" and ");
                if (subQuery.parentSubQuery == null) {
                    sqlBuilder.append(query.tableAliasName + "." + query.quickDAOConfig.database.escape(entry.getKey()) + " = " + subQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(entry.getValue()) + " ");
                    continue;
                }
                sqlBuilder.append(subQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(entry.getValue()) + " = " + subQuery.parentSubQuery.tableAliasName + "." + query.quickDAOConfig.database.escape(entry.getKey()) + " ");
            }
        }
    }

    private void addArraySQLParameters(PreparedStatement ps, Query query, Query mainQuery, StringBuilder builder) throws SQLException {
        for (Query selectQuery : query.selectQueryList) {
            this.addArraySQLParameters(ps, selectQuery, mainQuery, builder);
        }
        if (null != query.fromQuery) {
            this.addArraySQLParameters(ps, query.fromQuery, mainQuery, builder);
        }
        for (SubQuery subQuery : query.subQueryList) {
            if (null == subQuery.subQuery) continue;
            this.addArraySQLParameters(ps, subQuery.subQuery, mainQuery, builder);
        }
        this.addMainTableParameters(ps, query, mainQuery, builder);
    }

    protected void addMainTableParameters(PreparedStatement ps, Query query, Query mainQuery, StringBuilder sqlBuilder) throws SQLException {
        for (Object parameter : query.parameterList) {
            this.setParameter(parameter, ps, mainQuery.parameterIndex++, sqlBuilder);
        }
        for (Object parameter : query.havingParameterList) {
            this.setParameter(parameter, ps, mainQuery.parameterIndex++, sqlBuilder);
        }
    }

    private String insertArraySQL(Query query) {
        StringBuilder builder = new StringBuilder("insert into " + query.entity.escapeTableName + "(");
        List<Property> properties = query.entity.properties;
        for (Property property : properties) {
            if (property.id && property.strategy.equals((Object)IdStrategy.AutoIncrement)) continue;
            builder.append(query.quickDAOConfig.database.escape(property.column) + ",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(") values(");
        for (Property property : properties) {
            if (property.id && property.strategy.equals((Object)IdStrategy.AutoIncrement)) continue;
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        return builder.toString();
    }

    private String columns(Entity entity, String tableAlias) {
        String key = "columns_" + entity.tableName + "_" + tableAlias + ((Object)((Object)this.quickDAOConfig.database)).getClass().getName();
        if (!this.quickDAOConfig.sqlCache.containsKey(key)) {
            StringBuilder builder = new StringBuilder();
            for (Property property : entity.properties) {
                builder.append(tableAlias + "." + this.quickDAOConfig.database.escape(property.column) + " as " + tableAlias + "_" + property.column + ",");
            }
            builder.deleteCharAt(builder.length() - 1);
            this.quickDAOConfig.sqlCache.put(key, builder.toString());
        }
        return this.quickDAOConfig.sqlCache.get(key);
    }
}

