/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql.ddl;

import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.ddl.DDLDAO;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class AbstractDDLDAO
extends AbstractSQLDAO
implements DDLDAO {
    private AbstractDDLBuilder ddlBuilder;

    public AbstractDDLDAO(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.ddlBuilder = quickDAOConfig.database.getDDLBuilderInstance(quickDAOConfig);
        this.sqlBuilder = this.ddlBuilder;
    }

    @Override
    public void create(Class clazz) {
        this.create(this.quickDAOConfig.getEntityByClassName(clazz.getName()));
    }

    @Override
    public void create(Entity entity) {
        try {
            this.ddlBuilder.createTable(entity);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void dropTable(Class clazz) {
        this.dropTable(this.quickDAOConfig.getEntityByClassName((String)clazz.getName()).tableName);
    }

    @Override
    public void dropTable(String tableName) {
        try {
            this.ddlBuilder.dropTable(tableName);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rebuild(Class clazz) {
        try {
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            this.ddlBuilder.rebuild(entity);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void rebuild(String tableName) {
        try {
            Collection<Entity> entityList = this.quickDAOConfig.entityMap.values();
            Predicate<Entity> findByTableName = entity -> entity.tableName.equals(tableName);
            Entity entity2 = entityList.stream().filter(findByTableName).findFirst().orElse(null);
            if (null == entity2) {
                entity2 = this.quickDAOConfig.dbEntityList.stream().filter(findByTableName).findFirst().orElse(null);
            }
            if (null == entity2) {
                throw new IllegalArgumentException("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
            }
            this.ddlBuilder.rebuild(entity2);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void createColumn(String tableName, Property property) {
        try {
            Entity entity = new Entity();
            entity.tableName = tableName;
            property.entity = entity;
            if (null != property.check) {
                if (!property.check.isEmpty() && !property.check.contains("(")) {
                    property.check = "(" + property.check + ")";
                }
                property.check = property.check.replace("#{" + property.name + "}", property.column);
                property.escapeCheck = property.check.replace(property.column, this.quickDAOConfig.database.escape(property.column));
            }
            this.ddlBuilder.createProperty(property);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Property dropColumn(String tableName, String column) {
        Entity dbEntity = this.quickDAOConfig.dbEntityList.stream().filter(entity -> entity.tableName.equals(tableName)).findFirst().orElse(null);
        if (null == dbEntity) {
            throw new IllegalArgumentException("\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        Property deleteProperty = dbEntity.properties.stream().filter(property -> property.column.equals(column)).findFirst().orElse(null);
        if (null == deleteProperty) {
            throw new IllegalArgumentException("\u5217\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName + ",\u5217\u540d:" + column);
        }
        try {
            this.ddlBuilder.dropColumn(deleteProperty);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return deleteProperty;
    }

    @Override
    public boolean hasIndex(String tableName, String indexName) {
        try {
            return this.ddlBuilder.hasIndexExists(tableName, indexName);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void createIndex(IndexField indexField) {
        try {
            this.ddlBuilder.createIndex(indexField);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        try {
            this.ddlBuilder.dropIndex(tableName, indexName);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void enableForeignConstraintCheck(boolean enable) {
        try {
            this.ddlBuilder.enableForeignConstraintCheck(enable);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public Map<String, String> getTypeFieldMapping() {
        return this.ddlBuilder.getTypeFieldMapping();
    }

    @Override
    public void syncEntityList() {
        if (this.quickDAOConfig.packageNameMap.isEmpty() && this.quickDAOConfig.entityClassMap.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u5148\u6307\u5b9a\u8981\u626b\u63cf\u7684\u5b9e\u4f53\u7c7b\u5305\u6216\u8005\u5b9e\u4f53\u7c7b!");
        }
        try {
            this.ddlBuilder.automaticCreateTableAndColumn();
            Collection<Entity> entityList = this.quickDAOConfig.entityMap.values();
            for (Entity dbEntity : this.quickDAOConfig.dbEntityList) {
                Entity entity = entityList.stream().filter(entity1 -> entity1.tableName.equals(dbEntity.tableName)).findFirst().orElse(null);
                if (null == entity) {
                    this.dropTable(dbEntity.tableName);
                    continue;
                }
                for (Property dbProperty : dbEntity.properties) {
                    Property property = entity.properties.stream().filter(property1 -> property1.column.equals(dbProperty.column)).findFirst().orElse(null);
                    if (null != property) continue;
                    this.dropColumn(dbEntity.tableName, dbProperty.column);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void automaticCreateTableAndColumn() {
        try {
            this.refreshDbEntityList();
            this.ddlBuilder.automaticCreateTableAndColumn();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public void refreshDbEntityList() {
        try {
            this.ddlBuilder.refreshDbEntityList();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

