/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.dao.sql.dql;

import cn.schoolwow.quickdao.builder.dql.AbstractDQLBuilder;
import cn.schoolwow.quickdao.dao.sql.AbstractSQLDAO;
import cn.schoolwow.quickdao.dao.sql.dql.DQLDAO;
import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SFunction;
import cn.schoolwow.quickdao.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.util.LambdaUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class AbstractDQLDAO
extends AbstractSQLDAO
implements DQLDAO {
    private AbstractDQLBuilder dqlBuilder;

    public AbstractDQLDAO(QuickDAOConfig quickDAOConfig) {
        super(quickDAOConfig);
        this.dqlBuilder = quickDAOConfig.database.getDQLBuilderInstance(quickDAOConfig);
        this.sqlBuilder = this.dqlBuilder;
    }

    @Override
    public <T> T fetch(Class<T> clazz, long id) {
        return this.fetch(clazz, this.quickDAOConfig.getEntityByClassName((String)clazz.getName()).id.column, (Object)id);
    }

    @Override
    public <T> T fetch(Class<T> clazz, String field, Object value) {
        List<T> list = this.fetchList(clazz, field, value);
        if (null == list || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, String field, Object value) {
        try {
            ConnectionExecutorItem connectionExecutorItem = null;
            connectionExecutorItem = null == value ? this.dqlBuilder.fetchNull(clazz, field) : this.dqlBuilder.fetch(clazz, field, value);
            Entity entity = this.quickDAOConfig.getEntityByClassName(clazz.getName());
            ResultSet resultSet = this.sqlBuilder.connectionExecutor.executeQuery(connectionExecutorItem);
            JSONArray array = new JSONArray();
            while (resultSet.next()) {
                array.add((Object)this.quickDAOConfig.database.getObject(entity, "t", resultSet));
            }
            resultSet.close();
            return array.toJavaList(clazz);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public <T> T fetch(Class<T> clazz, SFunction<T, ?> field, Object value) {
        try {
            String convertField = LambdaUtils.resolveLambdaProperty(field);
            return this.fetch(clazz, convertField, value);
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public <T> List<T> fetchList(Class<T> clazz, SFunction<T, ?> field, Object value) {
        try {
            String convertField = LambdaUtils.resolveLambdaProperty(field);
            return this.fetchList(clazz, convertField, value);
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
    }

    @Override
    public JSONObject fetch(String tableName, String field, Object value) {
        JSONArray array = this.fetchList(tableName, field, value);
        if (null == array || array.isEmpty()) {
            return null;
        }
        return array.getJSONObject(0);
    }

    @Override
    public JSONArray fetchList(String tableName, String field, Object value) {
        try {
            ConnectionExecutorItem connectionExecutorItem = null;
            connectionExecutorItem = null == value ? this.dqlBuilder.fetchNull(tableName, field) : this.dqlBuilder.fetch(tableName, field, value);
            Entity dbEntity = this.quickDAOConfig.getDbEntityByTableName(tableName);
            ResultSet resultSet = this.sqlBuilder.connectionExecutor.executeQuery(connectionExecutorItem);
            JSONArray array = new JSONArray();
            while (resultSet.next()) {
                array.add((Object)this.quickDAOConfig.database.getObject(dbEntity, "t", resultSet));
            }
            resultSet.close();
            return array;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

