/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain;

import cn.schoolwow.quickdao.domain.ConnectionExecutorItem;
import cn.schoolwow.quickdao.domain.Interceptor;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SQLStatementType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionExecutor {
    private Logger logger = LoggerFactory.getLogger(ConnectionExecutor.class);
    public int count = -1;
    public Connection connection;
    public QuickDAOConfig quickDAOConfig;

    public ConnectionExecutor(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    public ConnectionExecutorItem newConnectionExecutorItem(String name, String sql) throws SQLException {
        try {
            PreparedStatement preparedStatement = sql.startsWith("insert ") ? this.connection.prepareStatement(sql, 1) : this.connection.prepareStatement(sql);
            ConnectionExecutorItem connectionExecutorItem = new ConnectionExecutorItem();
            connectionExecutorItem.name = name;
            connectionExecutorItem.sql = sql;
            connectionExecutorItem.preparedStatement = preparedStatement;
            return connectionExecutorItem;
        }
        catch (SQLException e) {
            this.logger.warn("[SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25]\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)name, (Object)sql);
            throw e;
        }
    }

    public ResultSet executeQuery(String name, String sql) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        ResultSet resultSet = this.executeQuery(name, sql, preparedStatement);
        return resultSet;
    }

    public ResultSet executeQuery(ConnectionExecutorItem connectionExecutorItem) throws SQLException {
        return this.executeQuery(connectionExecutorItem.name, connectionExecutorItem.sql, connectionExecutorItem.preparedStatement);
    }

    public int executeUpdate(String name, String sql) throws SQLException {
        PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
        int effect = this.executeUpdate(name, sql, preparedStatement);
        preparedStatement.close();
        return effect;
    }

    public int executeUpdate(ConnectionExecutorItem connectionExecutorItem) throws SQLException {
        return this.executeUpdate(connectionExecutorItem.name, connectionExecutorItem.sql, connectionExecutorItem.preparedStatement);
    }

    private ResultSet executeQuery(String name, String sql, PreparedStatement preparedStatement) throws SQLException {
        try {
            long startTime = System.currentTimeMillis();
            ResultSet resultSet = preparedStatement.executeQuery();
            long endTime = System.currentTimeMillis();
            if (!"\u83b7\u53d6\u884c\u6570".equals(name)) {
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                if (stackTraceElements[3].getClassName().startsWith("cn.schoolwow.quickdao.builder.ddl")) {
                    if (this.count >= 0) {
                        this.logger.trace("[{}]\u884c\u6570:{},\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", new Object[]{name, this.count, endTime - startTime, sql});
                        this.count = -1;
                    } else {
                        this.logger.trace("[{}]\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", new Object[]{name, endTime - startTime, sql});
                    }
                } else if (this.count >= 0) {
                    this.logger.debug("[{}]\u884c\u6570:{},\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", new Object[]{name, this.count, endTime - startTime, sql});
                    this.count = -1;
                } else {
                    this.logger.debug("[{}]\u8017\u65f6:{}ms,\u6267\u884cSQL:{}", new Object[]{name, endTime - startTime, sql});
                }
                for (Interceptor interceptor : this.quickDAOConfig.interceptorList) {
                    interceptor.afterExecuteConnection(SQLStatementType.SELECT, name, sql);
                }
            }
            return resultSet;
        }
        catch (SQLException e) {
            this.logger.warn("[SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25]\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)name, (Object)sql);
            throw e;
        }
    }

    private int executeUpdate(String name, String sql, PreparedStatement preparedStatement) throws SQLException {
        try {
            long startTime = System.currentTimeMillis();
            int effect = preparedStatement.executeUpdate();
            long endTime = System.currentTimeMillis();
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements[3].getClassName().startsWith("cn.schoolwow.quickdao.builder.ddl")) {
                this.logger.trace("[{}]\u8017\u65f6:{}ms,\u5f71\u54cd\u884c\u6570:{},\u6267\u884cSQL:{}", new Object[]{name, endTime - startTime, effect, sql});
            } else {
                this.logger.debug("[{}]\u8017\u65f6:{}ms,\u5f71\u54cd\u884c\u6570:{},\u6267\u884cSQL:{}", new Object[]{name, endTime - startTime, effect, sql});
            }
            for (Interceptor interceptor : this.quickDAOConfig.interceptorList) {
                interceptor.afterExecuteConnection(SQLStatementType.UPDATE, name, sql);
            }
            return effect;
        }
        catch (SQLException e) {
            this.logger.warn("[SQL\u8bed\u53e5\u6267\u884c\u5931\u8d25]\u540d\u79f0:{},\u539f\u59cbSQL:{}", (Object)name, (Object)sql);
            throw e;
        }
    }
}

