/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.domain;

import cn.schoolwow.quickdao.builder.dcl.AbstractDCLBuilder;
import cn.schoolwow.quickdao.builder.dcl.MySQLDCLBuilder;
import cn.schoolwow.quickdao.builder.dcl.OracleDCLBuilder;
import cn.schoolwow.quickdao.builder.dcl.PostgreDCLBuilder;
import cn.schoolwow.quickdao.builder.ddl.AbstractDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.H2DDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.MySQLDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.OracleDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.PostgreDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.SQLServerDDLBuilder;
import cn.schoolwow.quickdao.builder.ddl.SQLiteDDLBuilder;
import cn.schoolwow.quickdao.builder.dql.AbstractDQLBuilder;
import cn.schoolwow.quickdao.builder.dql.OracleDQLBuilder;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.Query;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.SubQuery;
import cn.schoolwow.quickdao.query.condition.AbstractCondition;
import cn.schoolwow.quickdao.query.condition.Condition;
import cn.schoolwow.quickdao.query.condition.OracleCondition;
import cn.schoolwow.quickdao.query.condition.PostgreCondition;
import cn.schoolwow.quickdao.query.condition.SQLServerCondition;
import cn.schoolwow.quickdao.query.subCondition.AbstractSubCondition;
import cn.schoolwow.quickdao.query.subCondition.SQLiteSubCondition;
import cn.schoolwow.quickdao.query.subCondition.SubCondition;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public enum Database {
    MariaDB,
    Mysql,
    H2,
    SQLite,
    Postgre,
    SQLServer,
    Oracle;


    public String comment(String comment) {
        switch (this) {
            case MariaDB: 
            case Mysql: {
                return "comment \"" + comment + "\"";
            }
            case SQLite: {
                return "/* " + comment + " */";
            }
            case H2: 
            case Postgre: 
            case SQLServer: 
            case Oracle: {
                return "";
            }
        }
        return comment;
    }

    public String escape(String value) {
        switch (this) {
            case MariaDB: 
            case Mysql: 
            case SQLite: 
            case H2: {
                return "`" + value + "`";
            }
            case Postgre: 
            case SQLServer: 
            case Oracle: {
                return "\"" + value + "\"";
            }
        }
        return value;
    }

    public Condition getConditionInstance(Query query) {
        switch (this) {
            case MariaDB: 
            case Mysql: 
            case SQLite: 
            case H2: {
                return new AbstractCondition(query);
            }
            case Postgre: {
                return new PostgreCondition(query);
            }
            case SQLServer: {
                return new SQLServerCondition(query);
            }
            case Oracle: {
                return new OracleCondition(query);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
    }

    public SubCondition getSubConditionInstance(SubQuery subQuery) {
        switch (this) {
            case SQLite: {
                return new SQLiteSubCondition(subQuery);
            }
            case MariaDB: 
            case Mysql: 
            case H2: 
            case Postgre: 
            case SQLServer: 
            case Oracle: {
                return new AbstractSubCondition(subQuery);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
    }

    public AbstractDCLBuilder getDCLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        switch (this) {
            case MariaDB: 
            case Mysql: 
            case H2: {
                return new MySQLDCLBuilder(quickDAOConfig);
            }
            case Postgre: {
                return new PostgreDCLBuilder(quickDAOConfig);
            }
            case SQLite: {
                throw new IllegalArgumentException("SQLite\u4e0d\u652f\u6301\u521b\u5efa\u7528\u6237\u7b49\u64cd\u4f5c!");
            }
            case SQLServer: {
                throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u652f\u6301SQLServer\u7684DCL\u76f8\u5173\u64cd\u4f5c!");
            }
            case Oracle: {
                return new OracleDCLBuilder(quickDAOConfig);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
    }

    public AbstractDDLBuilder getDDLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        switch (this) {
            case MariaDB: 
            case Mysql: {
                return new MySQLDDLBuilder(quickDAOConfig);
            }
            case SQLite: {
                return new SQLiteDDLBuilder(quickDAOConfig);
            }
            case H2: {
                return new H2DDLBuilder(quickDAOConfig);
            }
            case Postgre: {
                return new PostgreDDLBuilder(quickDAOConfig);
            }
            case SQLServer: {
                return new SQLServerDDLBuilder(quickDAOConfig);
            }
            case Oracle: {
                return new OracleDDLBuilder(quickDAOConfig);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
    }

    public AbstractDQLBuilder getDQLBuilderInstance(QuickDAOConfig quickDAOConfig) {
        switch (this) {
            case Oracle: {
                return new OracleDQLBuilder(quickDAOConfig);
            }
            case MariaDB: 
            case Mysql: 
            case SQLite: 
            case H2: 
            case Postgre: 
            case SQLServer: {
                return new AbstractDQLBuilder(quickDAOConfig);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
    }

    public JSONObject getObject(Entity entity, String tableAliasName, ResultSet resultSet) throws SQLException {
        JSONObject subObject = new JSONObject(true);
        for (Property property : entity.properties) {
            String columnLabel;
            String columnName = tableAliasName + "_" + property.column;
            String string = columnLabel = property.name == null ? property.column : property.name;
            if (null == property.className) {
                subObject.put(columnLabel, resultSet.getObject(columnName));
                continue;
            }
            Object value = null;
            block27 : switch (property.className) {
                case "byte": {
                    value = resultSet.getByte(columnName);
                    break;
                }
                case "[B": {
                    value = resultSet.getBytes(columnName);
                    break;
                }
                case "boolean": {
                    value = resultSet.getBoolean(columnName);
                    break;
                }
                case "short": {
                    value = resultSet.getShort(columnName);
                    break;
                }
                case "int": {
                    value = resultSet.getInt(columnName);
                    break;
                }
                case "float": {
                    value = Float.valueOf(resultSet.getFloat(columnName));
                    break;
                }
                case "long": {
                    value = resultSet.getLong(columnName);
                    break;
                }
                case "double": {
                    value = resultSet.getDouble(columnName);
                    break;
                }
                case "java.util.Date": {
                    switch (this) {
                        case SQLite: {
                            value = resultSet.getString(columnName);
                            break block27;
                        }
                    }
                    Object date = resultSet.getDate(columnName);
                    if (null == date) break;
                    value = new Date(((Date)date).getTime());
                    break;
                }
                case "java.sql.Date": {
                    switch (this) {
                        case SQLite: {
                            value = resultSet.getString(columnName);
                            break block27;
                        }
                    }
                    value = resultSet.getDate(columnName);
                    break;
                }
                case "java.sql.Time": {
                    switch (this) {
                        case SQLite: {
                            value = resultSet.getString(columnName);
                            break block27;
                        }
                    }
                    value = resultSet.getTime(columnName);
                    break;
                }
                case "java.sql.Timestamp": {
                    switch (this) {
                        case SQLite: {
                            value = resultSet.getString(columnName);
                            break block27;
                        }
                    }
                    value = resultSet.getTimestamp(columnName);
                    break;
                }
                case "java.time.LocalDate": {
                    Object date;
                    switch (this) {
                        case SQLite: {
                            date = resultSet.getString(columnName);
                            if (null == date) break block27;
                            value = LocalDate.parse((CharSequence)date, DateTimeFormatter.ISO_DATE);
                            break;
                        }
                        default: {
                            date = resultSet.getTimestamp(columnName);
                            if (null == date) break block27;
                            value = Instant.ofEpochMilli(((Date)date).getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                            break;
                        }
                    }
                    break;
                }
                case "java.time.LocalDateTime": {
                    Object date;
                    switch (this) {
                        case SQLite: {
                            String datetime = resultSet.getString(columnName);
                            if (null == datetime) break block27;
                            value = LocalDateTime.parse(datetime, DateTimeFormatter.ISO_DATE_TIME);
                            break;
                        }
                        default: {
                            date = resultSet.getTimestamp(columnName);
                            if (null == date) break block27;
                            value = Instant.ofEpochMilli(((Date)date).getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                            break;
                        }
                    }
                    break;
                }
                case "java.sql.Array": {
                    value = resultSet.getArray(columnName);
                    break;
                }
                case "java.math.BigDecimal": {
                    value = resultSet.getBigDecimal(columnName);
                    break;
                }
                case "java.sql.Blob": {
                    value = resultSet.getBlob(columnName);
                    break;
                }
                case "java.sql.Clob": {
                    value = resultSet.getClob(columnName);
                    break;
                }
                case "java.sql.NClob": {
                    value = resultSet.getNClob(columnName);
                    break;
                }
                case "java.sql.Ref": {
                    value = resultSet.getRef(columnName);
                    break;
                }
                case "java.net.URL": {
                    value = resultSet.getURL(columnName);
                    break;
                }
                case "java.sql.RowId": {
                    value = resultSet.getRowId(columnName);
                    break;
                }
                case "java.sql.SQLXML": {
                    value = resultSet.getSQLXML(columnName);
                    break;
                }
                case "java.io.InputStream": {
                    value = resultSet.getBinaryStream(columnName);
                    break;
                }
                case "java.io.Reader": {
                    value = resultSet.getCharacterStream(columnName);
                    break;
                }
                default: {
                    value = resultSet.getObject(columnName);
                }
            }
            subObject.put(columnLabel, value);
        }
        return subObject;
    }

    public static Database getDatabaseByJdbcUrl(String jdbcUrl) {
        if (jdbcUrl.contains("jdbc:h2")) {
            return H2;
        }
        if (jdbcUrl.contains("jdbc:sqlite")) {
            return SQLite;
        }
        if (jdbcUrl.contains("jdbc:mysql")) {
            return Mysql;
        }
        if (jdbcUrl.contains("jdbc:mariadb")) {
            return MariaDB;
        }
        if (jdbcUrl.contains("jdbc:postgresql")) {
            return Postgre;
        }
        if (jdbcUrl.contains("jdbc:sqlserver:")) {
            return SQLServer;
        }
        if (jdbcUrl.contains("jdbc:oracle:")) {
            return Oracle;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!");
    }
}

