/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.handler;

import cn.schoolwow.quickdao.annotation.ColumnName;
import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.CompositeIndex;
import cn.schoolwow.quickdao.annotation.CompositeIndexes;
import cn.schoolwow.quickdao.annotation.Constraint;
import cn.schoolwow.quickdao.annotation.ForeignKey;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickdao.annotation.Index;
import cn.schoolwow.quickdao.annotation.Indexes;
import cn.schoolwow.quickdao.annotation.Table;
import cn.schoolwow.quickdao.annotation.TableField;
import cn.schoolwow.quickdao.annotation.TableName;
import cn.schoolwow.quickdao.annotation.UniqueField;
import cn.schoolwow.quickdao.domain.Entity;
import cn.schoolwow.quickdao.domain.GenerateEntityFileOption;
import cn.schoolwow.quickdao.domain.IndexField;
import cn.schoolwow.quickdao.domain.Property;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.handler.EntityHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntityHandler
implements EntityHandler {
    private Logger logger = LoggerFactory.getLogger(DefaultEntityHandler.class);
    private QuickDAOConfig quickDAOConfig;

    public DefaultEntityHandler(QuickDAOConfig quickDAOConfig) {
        this.quickDAOConfig = quickDAOConfig;
    }

    @Override
    public synchronized void getEntityMap() throws Exception {
        ArrayList<Class> classList = new ArrayList<Class>();
        for (String packageName : this.quickDAOConfig.packageNameMap.keySet()) {
            List<Class> packageClassList = this.scanEntity(packageName);
            for (Class c : packageClassList) {
                Entity entity = new Entity();
                if (c.getDeclaredAnnotation(TableName.class) != null) {
                    entity.tableName = c.getDeclaredAnnotation(TableName.class).value();
                } else if (packageName.length() + c.getSimpleName().length() + 1 == c.getName().length()) {
                    entity.tableName = this.quickDAOConfig.packageNameMap.get(packageName) + this.camel2Underline(c.getSimpleName());
                } else {
                    String string = c.getName().substring(packageName.length() + 1, c.getName().lastIndexOf(".")).replace(".", "_");
                    entity.tableName = this.quickDAOConfig.packageNameMap.get(packageName) + string + "@" + this.camel2Underline(c.getSimpleName());
                }
                entity.clazz = c;
                this.quickDAOConfig.entityMap.put(c.getName(), entity);
            }
            classList.addAll(packageClassList);
        }
        for (Class c : this.quickDAOConfig.entityClassMap.keySet()) {
            Entity entity = new Entity();
            entity.tableName = c.getDeclaredAnnotation(TableName.class) != null ? c.getDeclaredAnnotation(TableName.class).value() : (this.quickDAOConfig.entityClassMap.get(c).isEmpty() ? this.camel2Underline(c.getSimpleName()) : this.quickDAOConfig.entityClassMap.get(c) + "@" + this.camel2Underline(c.getSimpleName()));
            entity.clazz = c;
            this.quickDAOConfig.entityMap.put(c.getName(), entity);
            classList.add(c);
        }
        Map<String, String> typeFieldMapping = this.quickDAOConfig.database.getDDLBuilderInstance(this.quickDAOConfig).getTypeFieldMapping();
        for (Class c : classList) {
            UniqueField uniqueField;
            CompositeIndexes compositeIndexs;
            Table table;
            Object indexes;
            Field[] fields;
            Entity entity = this.quickDAOConfig.getEntityByClassName(c.getName());
            entity.escapeTableName = this.quickDAOConfig.database.escape(entity.tableName);
            ArrayList<Property> propertyList = new ArrayList<Property>();
            for (Field field : fields = this.getAllField(c)) {
                TableField tableField;
                Id id;
                if (this.isCompositProperty(field.getType())) {
                    if (!entity.compositFieldMap.containsKey(field.getType().getName())) {
                        entity.compositFieldMap.put(field.getType().getName(), new ArrayList());
                    }
                    entity.compositFieldMap.get(field.getType().getName()).add(field.getName());
                    continue;
                }
                Property property = new Property();
                property.column = null != field.getAnnotation(ColumnName.class) ? field.getAnnotation(ColumnName.class).value() : this.camel2Underline(field.getName());
                property.columnLabel = property.name = field.getName();
                property.clazz = field.getType();
                property.className = field.getType().getName();
                if (null != field.getAnnotation(ColumnType.class)) {
                    property.columnType = field.getAnnotation(ColumnType.class).value();
                } else if (typeFieldMapping.containsKey(property.className) && !typeFieldMapping.get(property.className).isEmpty()) {
                    property.columnType = typeFieldMapping.get(property.className);
                } else {
                    throw new IllegalArgumentException("Java\u7c7b\u578b" + property.className + "\u65e0\u6cd5\u81ea\u52a8\u5339\u914d\u6570\u636e\u5e93\u7c7b\u578b,\u8bf7\u4f7f\u7528@ColumnType\u6ce8\u89e3\u624b\u52a8\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b!");
                }
                Constraint constraint = field.getDeclaredAnnotation(Constraint.class);
                if (null != constraint) {
                    property.notNull = constraint.notNull();
                    if (null != property.check) {
                        if (!property.check.isEmpty() && !property.check.contains("(")) {
                            property.check = "(" + property.check + ")";
                        }
                        property.check = property.check.replace("#{" + property.name + "}", property.column);
                        property.escapeCheck = property.check.replace(property.column, this.quickDAOConfig.database.escape(property.column));
                    }
                    property.defaultValue = constraint.defaultValue();
                }
                if (null != (id = field.getDeclaredAnnotation(Id.class))) {
                    property.id = true;
                    property.strategy = id.strategy();
                }
                if (null != (tableField = field.getDeclaredAnnotation(TableField.class))) {
                    if (!tableField.function().isEmpty()) {
                        property.function = tableField.function().replace("#{" + property.name + "}", "?");
                    }
                    property.createdAt = tableField.createdAt();
                    property.updateAt = tableField.updatedAt();
                }
                ArrayList<Index> indexList = new ArrayList<Index>();
                if (null != field.getDeclaredAnnotation(Index.class)) {
                    indexList.add(field.getDeclaredAnnotation(Index.class));
                }
                if (null != (indexes = field.getDeclaredAnnotation(Indexes.class)) && indexes.value().length > 0) {
                    indexList.addAll(Arrays.asList(indexes.value()));
                }
                for (Index index : indexList) {
                    IndexField indexField = new IndexField();
                    indexField.tableName = entity.tableName;
                    indexField.indexType = index.indexType();
                    indexField.indexName = !index.indexName().isEmpty() ? index.indexName() : entity.tableName + "_" + indexField.indexType.name().toLowerCase() + "_" + property.column;
                    indexField.using = index.using();
                    indexField.comment = index.comment();
                    indexField.columns.add(property.column);
                    entity.indexFieldList.add(indexField);
                }
                if (null != field.getDeclaredAnnotation(Comment.class)) {
                    property.comment = field.getDeclaredAnnotation(Comment.class).value();
                }
                property.foreignKey = field.getDeclaredAnnotation(ForeignKey.class);
                property.entity = entity;
                propertyList.add(property);
            }
            entity.properties = propertyList;
            Comment comment = this.getFirstAnnotation(c, Comment.class);
            if (null != comment) {
                entity.comment = comment.value();
            }
            if (null != (table = this.getFirstAnnotation(c, Table.class))) {
                entity.charset = table.charset();
                entity.engine = table.engine();
            }
            ArrayList<CompositeIndex> compositeIndexList = new ArrayList<CompositeIndex>();
            CompositeIndex compositeIndexAnno = this.getFirstAnnotation(c, CompositeIndex.class);
            if (null != compositeIndexAnno) {
                compositeIndexList.add(compositeIndexAnno);
            }
            if (null != (compositeIndexs = this.getFirstAnnotation(c, CompositeIndexes.class))) {
                compositeIndexList.addAll(Arrays.asList(compositeIndexs.value()));
            }
            if (compositeIndexList.size() > 0) {
                StringBuilder builder = new StringBuilder();
                for (CompositeIndex compositeIndex : compositeIndexList) {
                    if (compositeIndex.columns().length == 0) continue;
                    IndexField indexField = new IndexField();
                    indexField.tableName = entity.tableName;
                    indexField.indexType = compositeIndex.indexType();
                    indexField.using = compositeIndex.using();
                    indexes = compositeIndex.columns();
                    int n = ((String[])indexes).length;
                    for (int i = 0; i < n; ++i) {
                        String column = indexes[i];
                        indexField.columns.add(entity.getColumnNameByFieldName(column));
                    }
                    indexField.comment = compositeIndex.comment();
                    if (!compositeIndex.indexName().isEmpty()) {
                        indexField.indexName = compositeIndex.indexName();
                    } else {
                        builder.setLength(0);
                        indexes = indexField.columns.iterator();
                        while (indexes.hasNext()) {
                            String column = (String)indexes.next();
                            builder.append(column + ",");
                        }
                        builder.deleteCharAt(builder.length() - 1);
                        indexField.indexName = entity.tableName + "_" + indexField.indexType.name().toLowerCase() + "_" + builder.toString();
                    }
                    entity.indexFieldList.add(indexField);
                }
            }
            if (null == (uniqueField = this.getFirstAnnotation(c, UniqueField.class))) continue;
            for (String column : uniqueField.columns()) {
                Property property = entity.getPropertyByFieldName(column);
                if (null == property) {
                    throw new IllegalArgumentException("UniqueField\u6ce8\u89e3\u53c2\u6570\u65e0\u6cd5\u5339\u914d\u5b57\u6bb5!\u7c7b:" + entity.clazz.getName() + ",\u5b57\u6bb5:" + column);
                }
                entity.uniqueProperties.add(property);
            }
        }
        for (Entity entity : this.quickDAOConfig.entityMap.values()) {
            if (this.quickDAOConfig.database.name().equals("H2")) {
                entity.tableName = entity.tableName.toUpperCase();
                entity.escapeTableName = this.quickDAOConfig.database.escape(entity.tableName);
            }
            for (Property property : entity.properties) {
                if (this.quickDAOConfig.database.name().equals("H2")) {
                    property.column = property.column.toUpperCase();
                }
                if (property.id) {
                    entity.id = property;
                    property.notNull = true;
                    property.comment = "\u81ea\u589eid";
                    if (property.strategy == IdStrategy.AutoIncrement && null != this.quickDAOConfig.idStrategy) {
                        property.strategy = this.quickDAOConfig.idStrategy;
                    }
                }
                if (null == property.foreignKey) continue;
                entity.foreignKeyProperties.add(property);
            }
        }
    }

    @Override
    public void generateEntityFile(GenerateEntityFileOption generateEntityFileOption) {
        if (this.quickDAOConfig.packageNameMap.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528packageName\u65b9\u6cd5\u6307\u5b9a\u5305\u540d");
        }
        this.quickDAOConfig.autoCreateTable = false;
        this.quickDAOConfig.autoCreateProperty = false;
        List<Entity> dbEntityList = this.quickDAOConfig.dbEntityList;
        if (null != generateEntityFileOption.tableFilter) {
            dbEntityList = dbEntityList.stream().filter(generateEntityFileOption.tableFilter).collect(Collectors.toList());
        }
        StringBuilder builder = new StringBuilder();
        String packageName = this.quickDAOConfig.packageNameMap.keySet().iterator().next();
        Set<Map.Entry<String, String>> typeFieldMappingEntrySet = this.quickDAOConfig.database.getDDLBuilderInstance(this.quickDAOConfig).getTypeFieldMapping().entrySet();
        for (Entity dbEntity : dbEntityList) {
            String newEntityClassName;
            String entityClassName = this.underline2Camel(dbEntity.tableName);
            entityClassName = entityClassName.toUpperCase().charAt(0) + entityClassName.substring(1);
            if (null != generateEntityFileOption.entityClassNameMapping && null != (newEntityClassName = generateEntityFileOption.entityClassNameMapping.apply(dbEntity, entityClassName)) && !newEntityClassName.isEmpty()) {
                entityClassName = newEntityClassName;
            }
            Path target = Paths.get(generateEntityFileOption.sourceClassPath + "/" + packageName.replace(".", "/") + "/" + entityClassName.replace(".", "/") + ".java", new String[0]);
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.warn("[\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25]\u539f\u56e0:{},\u6587\u4ef6\u5939\u8def\u5f84:{}", (Object)e.getMessage(), (Object)target.getParent());
                continue;
            }
            builder.setLength(0);
            builder.append("package " + packageName + (entityClassName.contains(".") ? "." + entityClassName.substring(0, entityClassName.lastIndexOf(".")) : "") + ";\n");
            builder.append("import cn.schoolwow.quickdao.annotation.*;\n\n");
            if (null != dbEntity.comment) {
                builder.append("@Comment(\"" + dbEntity.comment + "\")\n");
            }
            if (null != dbEntity.tableName) {
                builder.append("@TableName(\"" + dbEntity.tableName + "\")\n");
            }
            builder.append("public class " + (entityClassName.contains(".") ? entityClassName.substring(entityClassName.lastIndexOf(".") + 1) : entityClassName) + "{\n\n");
            for (Property property : dbEntity.properties) {
                if (null != property.comment && !property.comment.isEmpty()) {
                    builder.append("\t@Comment(\"" + property.comment.replaceAll("\r\n", "") + "\")\n");
                }
                if (property.id) {
                    builder.append("\t@Id\n");
                }
                builder.append("\t@ColumnName(\"" + property.column + "\")\n");
                builder.append("\t@ColumnType(\"" + property.columnType + "\")\n");
                if (property.columnType.contains("(")) {
                    property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
                }
                if (null != generateEntityFileOption.columnFieldTypeMapping) {
                    property.className = generateEntityFileOption.columnFieldTypeMapping.apply(property.columnType);
                }
                if (null == property.className) {
                    for (Map.Entry<String, String> entry : typeFieldMappingEntrySet) {
                        if (!entry.getValue().contains(property.columnType.toUpperCase())) continue;
                        property.className = entry.getKey().replace("java.lang.", "");
                        break;
                    }
                }
                if (null == property.className) {
                    this.logger.warn("[\u5b57\u6bb5\u7c7b\u578b\u5339\u914d\u5931\u8d25]\u8868\u540d:{}\u5b57\u6bb5\u540d\u79f0:{},\u7c7b\u578b:{}", new Object[]{dbEntity.tableName, property.column, property.columnType});
                    property.className = "{{" + property.columnType + "}}";
                }
                if (null == property.name || property.name.isEmpty()) {
                    property.name = this.underline2Camel(property.column);
                }
                builder.append("\tprivate " + property.className + " " + property.name + ";\n\n");
            }
            for (Property property : dbEntity.properties) {
                builder.append("\tpublic " + property.className + " get" + this.firstLetterUpper(property.name) + "(){\n\t\treturn this." + property.name + ";\n\t}\n\n");
                builder.append("\tpublic void set" + this.firstLetterUpper(property.name) + "(" + property.className + " " + property.name + "){\n\t\tthis." + property.name + " = " + property.name + ";\n\t}\n\n");
            }
            builder.append("\t@Override\n\tpublic String toString() {\n\t\treturn \"\\n{\\n\" +\n");
            for (Property property : dbEntity.properties) {
                builder.append("\t\t\t\"" + property.comment + ":\" + " + property.name + " + \"\\n\" +\n");
            }
            builder.replace(builder.length() - 3, builder.length(), ";");
            builder.append("\t}\n");
            builder.append("};");
            ByteArrayInputStream bais = new ByteArrayInputStream(builder.toString().getBytes());
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(bais, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<Class> scanEntity(String packageName) throws ClassNotFoundException, IOException {
        String packageNamePath = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(packageNamePath);
        if (url == null) {
            this.logger.warn("[\u5b9e\u4f53\u7c7b\u8def\u5f84\u4e0d\u5b58\u5728]{}", (Object)packageNamePath);
            return new ArrayList<Class>();
        }
        this.logger.info("[\u626b\u63cf\u5b9e\u4f53\u7c7b]\u5305\u540d:{}", (Object)packageName);
        final ArrayList<Class> classList = new ArrayList<Class>();
        switch (url.getProtocol()) {
            case "file": {
                File file = new File(url.getFile());
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                }
                final String indexOfString = packageName.replace(".", "/");
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        File f = file.toFile();
                        if (f.getName().endsWith(".class")) {
                            String path = f.getAbsolutePath().replace("\\", "/");
                            int startIndex = path.indexOf(indexOfString);
                            String className = path.substring(startIndex, path.length() - 6).replace("/", ".");
                            try {
                                classList.add(Class.forName(className));
                            }
                            catch (ClassNotFoundException e) {
                                DefaultEntityHandler.this.logger.warn("[\u5b9e\u4f53\u7c7b\u4e0d\u5b58\u5728]{}", (Object)className);
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                break;
            }
            case "jar": {
                JarFile jarFile;
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) break;
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    String jarEntryName = jarEntry.getName();
                    if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class")) continue;
                    String className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", ".");
                    classList.add(classLoader.loadClass(className));
                }
                break;
            }
        }
        if (classList.size() == 0) {
            this.logger.warn("[\u626b\u63cf\u5b9e\u4f53\u7c7b\u4fe1\u606f\u4e3a\u7a7a]\u524d\u7f00:{},\u5305\u540d:{}", (Object)this.quickDAOConfig.packageNameMap.get(packageName), (Object)packageName);
            return classList;
        }
        Stream<Class> stream = classList.stream().filter(clazz -> !this.needIgnoreClass((Class)clazz));
        return stream.collect(Collectors.toList());
    }

    private <T> T getFirstAnnotation(Class clazz, Class<T> annotation) {
        T annotation1 = null;
        while (null != clazz && null == annotation1) {
            annotation1 = clazz.getDeclaredAnnotation(annotation);
            clazz = clazz.getSuperclass();
        }
        return annotation1;
    }

    private Field[] getAllField(Class clazz) {
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        Class tempClass = clazz;
        while (null != tempClass) {
            AccessibleObject[] fields = tempClass.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isStatic(((Field)field).getModifiers()) || Modifier.isFinal(((Field)field).getModifiers()) || Modifier.isTransient(((Field)field).getModifiers())) {
                    this.logger.debug("[\u8df3\u8fc7\u5e38\u91cf\u6216\u9759\u6001\u53d8\u91cf]{},\u8be5\u5c5e\u6027\u88abstatic\u6216\u8005final\u4fee\u9970!", (Object)((Field)field).getName());
                    continue;
                }
                if (field.getDeclaredAnnotation(Ignore.class) != null) {
                    this.logger.debug("[\u8df3\u8fc7\u5b9e\u4f53\u5c5e\u6027]{},\u8be5\u5c5e\u6027\u88abIgnore\u6ce8\u89e3\u4fee\u9970!", (Object)((Field)field).getName());
                    continue;
                }
                if (((Field)field).getType().isArray() || !((Field)field).getType().isPrimitive() && this.isCollection(((Field)field).getType()) || this.needIgnoreClass(((Field)field).getType())) continue;
                ((Field)field).setAccessible(true);
                fieldList.add(field);
            }
            if (null == (tempClass = tempClass.getSuperclass()) || !"java.lang.Object".equals(tempClass.getName())) continue;
            break;
        }
        return fieldList.toArray(new Field[0]);
    }

    private boolean isCompositProperty(Class clazz) {
        Set<String> packageNameSet = this.quickDAOConfig.packageNameMap.keySet();
        for (String packageName : packageNameSet) {
            if (!clazz.getName().contains(packageName)) continue;
            return true;
        }
        Set<Class> classSet = this.quickDAOConfig.entityClassMap.keySet();
        for (Class c : classSet) {
            if (!c.getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isCollection(Class _class) {
        Stack<Class<?>[]> stack = new Stack<Class<?>[]>();
        stack.push(_class.getInterfaces());
        while (!stack.isEmpty()) {
            Class[] classes;
            for (Class clazz : classes = (Class[])stack.pop()) {
                if (clazz.getName().equals(Collection.class.getName())) {
                    return true;
                }
                Class<?>[] subClasses = clazz.getInterfaces();
                if (null == subClasses || subClasses.length <= 0) continue;
                stack.push(subClasses);
            }
        }
        return false;
    }

    private boolean needIgnoreClass(Class clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        if (clazz.getAnnotation(Ignore.class) != null) {
            return true;
        }
        if (null != this.quickDAOConfig.ignoreClassList) {
            for (Class _clazz : this.quickDAOConfig.ignoreClassList) {
                if (!_clazz.getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        if (null != this.quickDAOConfig.ignorePackageNameList) {
            for (String ignorePackageName : this.quickDAOConfig.ignorePackageNameList) {
                if (!clazz.getName().contains(ignorePackageName)) continue;
                return true;
            }
            for (Class _clazz : this.quickDAOConfig.entityClassMap.keySet()) {
                if (!_clazz.getName().equals(clazz.getName())) continue;
                return true;
            }
        }
        return null != this.quickDAOConfig.predicate && this.quickDAOConfig.predicate.test(clazz);
    }

    private String firstLetterUpper(String s) {
        char firstLetter = s.charAt(0);
        if (firstLetter >= 'a' && firstLetter <= 'z') {
            firstLetter = (char)(firstLetter - 32);
        }
        return firstLetter + s.substring(1);
    }

    private String camel2Underline(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (i == 0 && s.charAt(i) >= 'A' && s.charAt(i) <= 'Z') {
                sb.append((char)(s.charAt(i) + 32));
                continue;
            }
            if (s.charAt(i) >= 'A' && s.charAt(i) <= 'Z') {
                if (s.charAt(i - 1) >= 'a' && s.charAt(i - 1) <= 'z') {
                    sb.append("_");
                }
                sb.append((char)(s.charAt(i) + 32));
                continue;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private String underline2Camel(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '_') continue;
            if (i > 0 && s.charAt(i - 1) == '_') {
                if (s.charAt(i) >= 'a' && s.charAt(i) <= 'z') {
                    sb.append((char)(s.charAt(i) - 32));
                    continue;
                }
                sb.append(s.charAt(i));
                continue;
            }
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }
}

